﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/format/ovln_ControllerMessage.h>

#include "hid_ActivationCount.h"

namespace nn { namespace hid { namespace detail {

class OvlnSenderManager
{
    NN_DISALLOW_COPY(OvlnSenderManager);
    NN_DISALLOW_MOVE(OvlnSenderManager);

private:
    // OvlnSenderManagerがアクティベートされた回数
    ActivationCount m_ActivationCount;

    //!< 通知送信用の型
    nn::ovln::SenderForOverlayType m_Sender;

public:
    OvlnSenderManager() NN_NOEXCEPT;

    ::nn::Result Activate() NN_NOEXCEPT;

    ::nn::Result Deactivate() NN_NOEXCEPT;

    void Send(nn::ovln::format::ControllerAttachToConsoleData data) NN_NOEXCEPT;

    void Send(nn::ovln::format::ControllerBatteryLevelLowExData data) NN_NOEXCEPT;

    void Send(nn::ovln::format::ControllerDisconnectionData data) NN_NOEXCEPT;

    void Send(nn::ovln::format::ControllerPairingCompletedData data) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
