﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadColor.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_NpadGc.h>
#include <nn/hid/hid_NpadPalma.h>

#include "hid_NpadUtilTypes.h"

namespace nn { namespace hid { namespace detail {

struct NpadStyleDefinition
{
    NpadStyleSet style;
    system::NpadDeviceTypeSet deviceType;
    NpadButtonSet buttonMask;
    NpadAttributesSet attributesMask;
    bool isSystem;
};

const NpadButtonSet ButtonMask_BasicSet = NpadButton::A::Mask |
                                          NpadButton::B::Mask |
                                          NpadButton::Y::Mask |
                                          NpadButton::X::Mask |
                                          NpadButton::StickL::Mask |
                                          NpadButton::StickR::Mask |
                                          NpadButton::L::Mask |
                                          NpadButton::R::Mask |
                                          NpadButton::ZL::Mask |
                                          NpadButton::ZR::Mask |
                                          NpadButton::Up::Mask |
                                          NpadButton::Right::Mask |
                                          NpadButton::Down::Mask |
                                          NpadButton::Left::Mask |
                                          NpadButton::Plus::Mask |
                                          NpadButton::Minus::Mask |
                                          NpadButton::StickLUp::Mask |
                                          NpadButton::StickLRight::Mask |
                                          NpadButton::StickLDown::Mask |
                                          NpadButton::StickLLeft::Mask |
                                          NpadButton::StickRUp::Mask |
                                          NpadButton::StickRRight::Mask |
                                          NpadButton::StickRDown::Mask |
                                          NpadButton::StickRLeft::Mask;
const NpadButtonSet ButtonMask_JoyLeft =  NpadJoyButton::L::Mask |
                                          NpadJoyButton::ZL::Mask |
                                          NpadJoyButton::StickL::Mask |
                                          NpadJoyButton::Up::Mask |
                                          NpadJoyButton::Right::Mask |
                                          NpadJoyButton::Down::Mask |
                                          NpadJoyButton::Left::Mask |
                                          NpadJoyButton::Minus::Mask |
                                          NpadJoyButton::LeftSL::Mask |
                                          NpadJoyButton::LeftSR::Mask |
                                          NpadJoyButton::StickLUp::Mask |
                                          NpadJoyButton::StickLRight::Mask |
                                          NpadJoyButton::StickLDown::Mask |
                                          NpadJoyButton::StickLLeft::Mask;
const NpadButtonSet ButtonMask_JoyRight = NpadJoyButton::A::Mask |
                                         NpadJoyButton::B::Mask |
                                         NpadJoyButton::Y::Mask |
                                         NpadJoyButton::X::Mask |
                                         NpadJoyButton::R::Mask |
                                         NpadJoyButton::ZR::Mask |
                                         NpadJoyButton::StickR::Mask |
                                         NpadJoyButton::Plus::Mask |
                                         NpadJoyButton::RightSL::Mask |
                                         NpadJoyButton::RightSR::Mask |
                                         NpadJoyButton::StickRUp::Mask |
                                         NpadJoyButton::StickRRight::Mask |
                                         NpadJoyButton::StickRDown::Mask |
                                         NpadJoyButton::StickRLeft::Mask;
const NpadButtonSet ButtonMask_Palma =    NpadPalmaButton::Palma::Mask |
                                          NpadPalmaButton::StickL::Mask |
                                          NpadPalmaButton::StickLUp::Mask |
                                          NpadPalmaButton::StickLRight::Mask |
                                          NpadPalmaButton::StickLDown::Mask |
                                          NpadPalmaButton::StickLLeft::Mask;
const NpadButtonSet ButtonMask_System  = NpadButton::A::Mask |
                                         NpadButton::B::Mask |
                                         NpadButton::Y::Mask |
                                         NpadButton::X::Mask |
                                         NpadButton::L::Mask |
                                         NpadButton::R::Mask |
                                         NpadButton::Up::Mask |
                                         NpadButton::Right::Mask |
                                         NpadButton::Down::Mask |
                                         NpadButton::Left::Mask |
                                         NpadButton::StickLUp::Mask |
                                         NpadButton::StickLRight::Mask |
                                         NpadButton::StickLDown::Mask |
                                         NpadButton::StickLLeft::Mask |
                                         NpadButton::StickRUp::Mask |
                                         NpadButton::StickRRight::Mask |
                                         NpadButton::StickRDown::Mask |
                                         NpadButton::StickRLeft::Mask;

const NpadAttributesSet AttributesMask_DefaultAttributes =
    NpadAttribute::IsConnected::Mask |
    NpadAttribute::IsWired::Mask;

const NpadAttributesSet AttributesMask_JoyAttributes =
    NpadAttribute::IsConnected::Mask |
    NpadAttribute::IsWired::Mask |
    NpadJoyAttribute::IsLeftConnected::Mask |
    NpadJoyAttribute::IsLeftWired::Mask |
    NpadJoyAttribute::IsRightConnected::Mask |
    NpadJoyAttribute::IsRightWired::Mask;

const NpadStyleDefinition NpadStyleDefinitions[] = {
    // NpadStyleFullKey の定義
    {
        NpadStyleFullKey::Mask,                                  // style
        (                                                        // deviceType
            system::DeviceType::FullKeyController::Mask |
            DeviceTypeMask_JoyCons
        ),
        ButtonMask_BasicSet,                                     // buttonMask
        AttributesMask_DefaultAttributes,                        // Attribute
        false,                                                   // isSystem
    },

    // NpadStyleHandheld の定義
    {
        NpadStyleHandheld::Mask,                                 // style
        (                                                        // deviceType
            DeviceTypeMask_HandheldJoyCons
        ),
        ButtonMask_BasicSet,                                     // buttonMask
        AttributesMask_JoyAttributes,                            // Attribute
        false,                                                   // isSystem
    },

    // NpadStyleJoyDual の定義
    {
        NpadStyleJoyDual::Mask,                                 // style
        (                                                        // deviceType
            DeviceTypeMask_JoyCons
        ),
        (                                                        // buttonMask
            ButtonMask_JoyLeft |
            ButtonMask_JoyRight
        ),
        AttributesMask_JoyAttributes,                            // Attribute
        false,                                                   // isSystem
    },

    // NpadStyleJoyLeft の定義
    {
        NpadStyleJoyLeft::Mask,                                  // style
        (                                                        // deviceType
            system::DeviceType::JoyConLeft::Mask
        ),
        ButtonMask_JoyLeft,                                      // buttonMask
        AttributesMask_JoyAttributes,                            // Attribute
        false,                                                   // isSystem
    },

    // NpadStyleJoyRight の定義
    {
        NpadStyleJoyRight::Mask,                                 // style
        (                                                        // deviceType
            system::DeviceType::JoyConRight::Mask
        ),
        ButtonMask_JoyRight,                                     // buttonMask
        AttributesMask_JoyAttributes,                            // Attribute
        false,                                                   // isSystem
    },

    // NpadStyleSystemExt の定義
    {
        system::NpadStyleSystemExt::Mask,                        // style
        (                                                        // deviceType
            system::DeviceType::FullKeyController::Mask |
            DeviceTypeMask_JoyCons|
            DeviceTypeMask_HandheldJoyCons
        ),
        ButtonMask_BasicSet,                                     // buttonMask
        AttributesMask_JoyAttributes,                            // Attribute
        true,                                                    // isSystem
    },

    // NpadStylePalma の定義
    {
        NpadStylePalma::Mask,                                    // style
        (                                                        // deviceType
            system::DeviceType::Palma::Mask
        ),
        ButtonMask_Palma,                                        // buttonMask
        AttributesMask_DefaultAttributes,                        // Attribute
        false,                                                   // isSystem
    },
};

const int NpadStyleCountMax = NN_ARRAY_SIZE(NpadStyleDefinitions);

enum NpadStyleDefinitionIndex
{
    NpadStyleDefinitionIndex_FullKey,
    NpadStyleDefinitionIndex_Handheld,
    NpadStyleDefinitionIndex_JoyDual,
    NpadStyleDefinitionIndex_JoyLeft,
    NpadStyleDefinitionIndex_JoyRight,
    NpadStyleDefinitionIndex_SystemExt,
    NpadStyleDefinitionIndex_Palma,
};

}}} // namespace nn::hid::detail
