﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/xcd/xcd_BleDevice.h>

#include "hid_ActivationCount.h"
#include "hid_NpadAbstractedPadHolder.h"
#include "hid_NpadDeviceManager.h"
#include "hid_PalmaResourceManager.h"

namespace nn { namespace hid { namespace detail {

//!< Palma の状態の制御を担うクラスです。
class NpadPalmaController final
{
    NN_DISALLOW_COPY(NpadPalmaController);
    NN_DISALLOW_MOVE(NpadPalmaController);

private:
    //!< Npad 毎に割り当てられる AbstractedPad を保持するクラス
    NpadAbstractedPadHolder* m_pAbstractedPadHolder;

    //!< Npad の状態管理を担うマネージャー
    NpadDeviceManager* m_pDeviceManager;

    //!< Palma の管理を行うリソースマネージャー
    PalmaResourceManager* m_pPalmaResourceManager;

    //!< アクティブ化された回数
    ActivationCount m_NpadActivationCount;

    //!< Palma に割り当てられた Xcd デバイスのハンドル
    nn::xcd::BleConnectionHandle m_XcdBleConnectionHandle;

public:
    NpadPalmaController() NN_NOEXCEPT;

    ~NpadPalmaController() NN_NOEXCEPT;

    //!< NpadAbstractedPadHolder を設定します。
    void SetNpadAbstractedPadHolder(NpadAbstractedPadHolder* pHolder) NN_NOEXCEPT;

    //!< NpadDeviceManager を設定します。
    void SetNpadDeviceManager(NpadDeviceManager* pHolder) NN_NOEXCEPT;

    //!< PalmaResourceManager を設定します。
    void SetPalmaResourceManager(PalmaResourceManager* pManager) NN_NOEXCEPT;

    //!< アクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< 非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< Palma の状態を更新します。
    void UpdateDeviceStates() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
