﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include "hid_ActivationCount.h"
#include "hid_NpadCommonResourceHolder.h"
#include "hid_NpadManager.h"

namespace nn { namespace hid { namespace detail {

//!< 最後に操作されたコントローラーの監視を行うクラスです。
class NpadLastActiveControllerMonitor final
{
    NN_DISALLOW_COPY(NpadLastActiveControllerMonitor) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(NpadLastActiveControllerMonitor) NN_NOEXCEPT;

private:
    //!< Npad が共通で扱う hid のサービスを保持するクラス
    NpadCommonResourceHolder* m_pCommonResourceHolder;

    //!< NpadManager の配列
    NpadManagerArray* m_pNpads;

    //!< アクティブ化された回数
    ActivationCount m_ActivationCount;

    //!< 最後に操作が行われた NpadManager への index
    int m_LastActiveNpadIndex;

    //!< 最後に操作が行われた Npad が存在するかどうか
    bool m_IsLastActiveNpadExist;

public:
    NpadLastActiveControllerMonitor() NN_NOEXCEPT;

    ~NpadLastActiveControllerMonitor() NN_NOEXCEPT;

    //!< NpadCommonResourceHolder を設定します。
    void SetNpadCommonResourceHolder(NpadCommonResourceHolder* pHolder) NN_NOEXCEPT;

    //!< NpadManager の配列をセットします。
    void SetNpadManagers(NpadManagerArray* pNpads) NN_NOEXCEPT;

    //!< アクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< 非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< 最後に操作されたコントローラーを設定します。
    void SetLastActiveNpad(const NpadIdType& id) NN_NOEXCEPT;

    //!< 最後に操作されたコントローラーを取得します。
    ::nn::Result GetLastActiveNpad(NpadIdType* pOutValue) NN_NOEXCEPT;

    //!< 最後に操作したコントローラーの更新します。
    void UpdateLastActiveNpad() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
