﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_IHidServer.sfdl.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_NpadCommonTypes.h>

#include "hid_AppletResourceUserId.h"
#include "hid_HidServer.h"
#include "hid_NpadCommonImpl.h"

namespace nn { namespace hid { namespace detail {

::nn::Result SetSupportedNpadStyleSet(::nn::hid::NpadStyleSet style) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetSupportedNpadStyleSet(GetAppletResourceUserId(), style));

    NN_RESULT_SUCCESS;
}

::nn::Result GetSupportedNpadStyleSet(::nn::hid::NpadStyleSet* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->GetSupportedNpadStyleSet(GetAppletResourceUserId(), pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetSupportedNpadIdType(const ::nn::hid::NpadIdType* pNpadIds, int count) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(
        pProxy->SetSupportedNpadIdType(GetAppletResourceUserId(),
                               ::nn::sf::InArray<NpadIdType>(
                               pNpadIds, static_cast<size_t>(count))));

    NN_RESULT_SUCCESS;
}

::nn::Result SetNpadJoyHoldType(NpadJoyHoldType holdType) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetNpadJoyHoldType(GetAppletResourceUserId(), static_cast<int64_t>(holdType)));

    NN_RESULT_SUCCESS;
}

::nn::Result GetNpadJoyHoldType(NpadJoyHoldType* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    int64_t holdType;
    NN_RESULT_DO(pProxy->GetNpadJoyHoldType(GetAppletResourceUserId(), &holdType));

    switch (holdType)
    {
    case NpadJoyHoldType_Horizontal:
        *pOutValue = NpadJoyHoldType_Horizontal;
        break;
    case NpadJoyHoldType_Vertical:
        *pOutValue = NpadJoyHoldType_Vertical;
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    NN_RESULT_SUCCESS;
}

::nn::Result StartLrAssignmentMode() NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->StartLrAssignmentMode(GetAppletResourceUserId()));

    NN_RESULT_SUCCESS;
}

::nn::Result StopLrAssignmentMode() NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->StopLrAssignmentMode(GetAppletResourceUserId()));
    NN_RESULT_SUCCESS;
}

::nn::Result SetNpadHandheldActivationMode(NpadHandheldActivationMode mode) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetNpadHandheldActivationMode(GetAppletResourceUserId(), static_cast<int64_t>(mode)));

    NN_RESULT_SUCCESS;
}

::nn::Result GetNpadHandheldActivationMode(NpadHandheldActivationMode* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    int64_t mode;
    NN_RESULT_DO(pProxy->GetNpadHandheldActivationMode(GetAppletResourceUserId(), &mode));

    switch (mode)
    {
    case NpadHandheldActivationMode_Dual:
        *pOutValue = NpadHandheldActivationMode_Dual;
        break;
    case NpadHandheldActivationMode_Single:
        *pOutValue = NpadHandheldActivationMode_Single;
        break;
    case NpadHandheldActivationMode_None:
        *pOutValue = NpadHandheldActivationMode_None;
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    NN_RESULT_SUCCESS;
}

::nn::Result SetNpadCommunicationMode(NpadCommunicationMode mode) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->SetNpadCommunicationMode(GetAppletResourceUserId(), static_cast<int64_t>(mode)));

    NN_RESULT_SUCCESS;
}

::nn::Result GetNpadCommunicationMode(NpadCommunicationMode* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    int64_t mode;
    NN_RESULT_DO(pProxy->GetNpadCommunicationMode(&mode));

    switch (mode)
    {
    case NpadCommunicationMode_5ms:
        *pOutValue = NpadCommunicationMode_5ms;
        break;
    case NpadCommunicationMode_10ms:
        *pOutValue = NpadCommunicationMode_10ms;
        break;
    case NpadCommunicationMode_15ms:
        *pOutValue = NpadCommunicationMode_15ms;
        break;
    case NpadCommunicationMode_Default:
        *pOutValue = NpadCommunicationMode_Default;
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    NN_RESULT_SUCCESS;
}

::nn::Result EnableUnintendedHomeButtonInputProtection(const NpadIdType& id, bool enabled) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<IHidServer>();
    CreateHidServerProxy(&pProxy);

    NN_RESULT_DO(pProxy->EnableUnintendedHomeButtonInputProtection(GetAppletResourceUserId(), id, enabled));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::hid::detail
