﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitPack.h>

namespace nn { namespace hid { namespace detail {

enum class OperationMode : int8_t
{
    Ready,
    Moment,
    Dpd,
    Segmentation,
    Clustering,
    SpiImage,
    SpiCompressedImage,
    Sleep,
};

struct IrSensorRegisterCurrentOperationMode final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x71;
    typedef ::nn::util::BitPack8::Field<0, 3, int8_t> Mode;
};

struct IrSensorRegisterManualGain0 final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x2E;
};

struct IrSensorRegisterManualGain1 final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x2F;
};

enum class GainCode : uint16_t
{
    X0 = 0,
    X1 = 16,
    X2 = 32,
    X3 = 48,
    X4 = 64,
    X5 = 80,
    X6 = 96,
    X7 = 112,
    X8 = 128,
    X9 = 144,
    X10 = 160,
    X11 = 176,
    X12 = 192,
    X13 = 208,
    X14 = 224,
    X15 = 240,
    X16 = 256,
};

struct IrSensorRegisterManualExposureTime0 final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x30;
};

struct IrSensorRegisterManualExposureTime1 final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x31;
};

struct IrSensorRegisterManualExposureTime2 final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x32;
};

struct IrSensorRegisterIntensityThresholdHeader final
{
    static const int Bank = 1;
    static const uint8_t Address = 0x43;
};

enum class FrameSubtractionMode : int8_t
{
    NoSubtraction,
    TimeDifference,
    Trigger,
    LedOnOffSubtraction,
};

enum class FrameDifferenceMode : int8_t
{
    AbsoluteValue,
    ClampedValue,
    ClampedValuePlus128,
};

struct IrSensorRegisterFrameSubtraction final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x0E;
    typedef ::nn::util::BitPack8::Field<0, 2, int8_t> FrameSubtractionMode;
    typedef ::nn::util::BitPack8::Field<2, 1, bool> UseNegativeImage;
    typedef ::nn::util::BitPack8::Field<4, 2, int8_t> FrameDifferenceMode;
};

enum class IrCameraFrameInterval : uint8_t
{
    Moment             = 71, // 140fps
    Dpd                = 50,
    Segmentation       = 50,
    Clustering         = 71, // 140fps
    SpiImage           = 71, // 140fps
    SpiCompressedImage = 50,
};

struct IrSensorRegisterPowerControl final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x03;
};

struct IrSensorRegisterIrCameraFrameRate final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x04;
};

struct IrSensorRegisterIrCameraLight final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x10;
    typedef ::nn::util::BitPack8::Field<0, 1, bool> EnableAlwaysOn;
    typedef ::nn::util::BitPack8::Field<4, 1, bool> DisableSmallAngleLight;
    typedef ::nn::util::BitPack8::Field<5, 1, bool> DisableLargeAngleLight;
    typedef ::nn::util::BitPack8::Field<7, 1, bool> EnableLightSwitchMode;
};

struct IrSensorRegisterWindowOfInterestX final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x14;
};

struct IrSensorRegisterWindowOfInterestY final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x15;
};

struct IrSensorRegisterWindowOfInterestWidth final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x16;
};

struct IrSensorRegisterWindowOfInterestHeight final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x17;
};

struct IrSensorRegisterWindowOfInterestBit8 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x18;
    typedef ::nn::util::BitPack8::Field<0, 1, uint8_t> Width8;
    typedef ::nn::util::BitPack8::Field<1, 1, uint8_t> Height8;
    typedef ::nn::util::BitPack8::Field<4, 1, uint8_t> X8;
    typedef ::nn::util::BitPack8::Field<5, 1, uint8_t> Y8;
};

struct IrSensorRegisterEnableRegionOfInterest final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1A;
};

struct IrSensorRegisterRegionOfInterestX final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1B;
};

struct IrSensorRegisterRegionOfInterestY final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1C;
};

struct IrSensorRegisterRegionOfInterestWidth final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1D;
};

struct IrSensorRegisterRegionOfInterestHeight final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1E;
};

struct IrSensorRegisterRegionOfInterestBit8 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x1F;
    typedef ::nn::util::BitPack8::Field<0, 1, uint8_t> Width8;
    typedef ::nn::util::BitPack8::Field<1, 1, uint8_t> Height8;
    typedef ::nn::util::BitPack8::Field<4, 1, uint8_t> X8;
    typedef ::nn::util::BitPack8::Field<5, 1, uint8_t> Y8;
};

enum class BinningSkippingFactor : uint8_t
{
    X1 = 0,
    X2 = 1,
    X4 = 2,
    X8 = 3,
};

struct IrSensorRegisterBinningSkippingBit8 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x2E;
    typedef ::nn::util::BitPack8::Field<0, 2, uint8_t> HorizontalSkipping;
    typedef ::nn::util::BitPack8::Field<2, 2, uint8_t> VerticalSkipping;
    typedef ::nn::util::BitPack8::Field<4, 2, uint8_t> HorizontalBinning;
    typedef ::nn::util::BitPack8::Field<6, 1, uint8_t> VerticalBinning;
};

enum class MomentPreprocessMode : uint8_t
{
    NoiseCut,
    Binarization,
};

struct IrSensorRegisterMomentPreprocessMode final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x2A;
    typedef ::nn::util::BitPack8::Field<0, 1, MomentPreprocessMode> Mode;
};

struct IrSensorRegisterMomentXStep final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x2B;
};

struct IrSensorRegisterMomentYStep final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x2C;
};

struct IrSensorRegisterIntensityThreshold final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x20;
};

struct IrSensorRegisterClusteringObjectPixelCountMin0 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x21;
};

struct IrSensorRegisterClusteringObjectPixelCountMin1 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x22;
};

struct IrSensorRegisterClusteringObjectPixelCountMin2 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x23;
};

struct IrSensorRegisterClusteringObjectPixelCountMax0 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x24;
};

struct IrSensorRegisterClusteringObjectPixelCountMax1 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x25;
};

struct IrSensorRegisterClusteringObjectPixelCountMax2 final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x26;
};

struct IrSensorRegisterFastUpdate final
{
    static const int Bank = 0;
    static const uint8_t Address = 0x07;
    typedef ::nn::util::BitPack8::Field<0, 1, bool> Update;
};

}}} // namespace nn::hid::detail
