﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/system/hid_InputDetection.h>

namespace nn { namespace hid { namespace detail {

::nn::Result InitializeInputDetector() NN_NOEXCEPT;

::nn::Result FinalizeInputDetector() NN_NOEXCEPT;

::nn::Result GetInputSourceState(::nn::hid::system::InputSourceState* pOutValue,
                                 const ::nn::hid::system::InputSourceIdSet& id) NN_NOEXCEPT;

::nn::Result NotifyInputDetector(const ::nn::hid::system::InputSourceIdSet& id) NN_NOEXCEPT;

}}} // namespace nn::hid::detail
