﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

namespace nn { namespace hid { namespace detail {

//!< 携帯機で利用できる Hid の有効/無効を管理するクラスです。
class HandheldManager final
{
    NN_DISALLOW_COPY(HandheldManager);
    NN_DISALLOW_MOVE(HandheldManager);

private:
    //!< 携帯機の有効/無効状態
    ::std::atomic<bool> m_IsHandheldEnabled;

public:
    HandheldManager() NN_NOEXCEPT;

    //!< 携帯機で利用できる Hid の有効状態を取得します。
    bool IsHandheldEnabled() NN_NOEXCEPT{return m_IsHandheldEnabled;}

    //!< 携帯機で利用できる Hid の有効状態を設定します。
    void SetHandheldEnabled(bool enabled) NN_NOEXCEPT {m_IsHandheldEnabled = enabled;}
};

}}} // namespace nn::hid::detail
