﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/xcd/xcd_AttachmentDevice.h>
#include <nn/hid/hid_ExternalBus.h>

#include "hid_IExternalBusDriver.h"

namespace nn { namespace hid { namespace detail {

class ExternalBusXcdDriver final : public nn::hid::detail::IExternalBusDriver
{
    NN_DISALLOW_COPY(ExternalBusXcdDriver);
    NN_DISALLOW_MOVE(ExternalBusXcdDriver);

private:
    nn::xcd::DeviceHandle m_Handle;
    nn::os::SystemEvent   m_ReceiveEvent;
    nn::os::Mutex         m_EnableMutex;

public:
    ExternalBusXcdDriver() NN_NOEXCEPT
        : m_Handle()
        , m_ReceiveEvent(nn::os::EventClearMode_ManualClear, true)
        , m_EnableMutex(false)
    {}

    virtual ~ExternalBusXcdDriver() NN_NOEXCEPT NN_OVERRIDE
    {}

    virtual nn::Result Initialize() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Finalize() NN_NOEXCEPT NN_OVERRIDE;

    nn::Result SetXcdDeviceHandle(::nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
    virtual bool IsExternalConnecterDeviceConnected() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result EnableExternalConnecterDevice(bool isEnabled, uint64_t version) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetExternalConnecterDeviceInfo(ExternalBusDeviceInfo* pOutInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SendCommandAsyncToExternalBusDevice(const uint8_t* pInCommand, size_t inCommandSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetSendCommandAsynceResultFromExternalBusDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result SetEventForExternalBusDeviceSendCommandAsycResult(nn::os::SystemEventType* pReceiveEventHandle) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::os::SystemEvent* GetInternalReceiveEventPointer() NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_ReceiveEvent;
    }

    virtual nn::os::Mutex* GetInternalEnableMutexPointer() NN_NOEXCEPT NN_OVERRIDE
    {
        return &m_EnableMutex;
    }

    virtual nn::Result EnablePollingReceiveModeForAttachmentDevice(const uint8_t* pInCommand, size_t inCommandSize, ExternalBusJoyPollingMode mode) NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result DisablePollingReceiveModeForAttachmentDevice() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result GetPollingDataForAttachmentDevice(size_t* pOutSize, uint8_t* pOutCommand, size_t outCommandSize) NN_NOEXCEPT NN_OVERRIDE;

};

}}} // namespace nn::hid::detail
