﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/hid/detail/hid_Log.h>
#include <nn/settings/system/settings_SixAxisSensor.h>

namespace nn { namespace hid { namespace detail {

//!< キャリブレーションパラメータを表す構造体です。
struct ConsoleSixAxisSensorCalibrationParameters
{
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias
        consoleSixAxisSensorAccelerationBias;
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias
        consoleSixAxisSensorAngularVelocityBias;
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain
        consoleSixAxisSensorAccelerationGain;
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain
        consoleSixAxisSensorAngularVelocityGain;
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias
        consoleSixAxisSensorAngularVelocityTimeBias;
    ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration
        consoleSixAxisSensorAngularAcceleration;

    void Print() const NN_NOEXCEPT
    {
        NN_DETAIL_HID_TRACE(
            "ConsoleSixAxisSensor Calibration Parameter\n"
            "consoleSixAxisSensorAccelerationBias        : (%f, %f, %f)\n"
            "consoleSixAxisSensorAngularVelocityBias     : (%f, %f, %f)\n"
            "consoleSixAxisSensorAccelerationGain        : (%f, %f, %f, %f, %f, %f, %f, %f, %f)\n"
            "consoleSixAxisSensorAngularVelocityGain     : (%f, %f, %f, %f, %f, %f, %f, %f, %f)\n"
            "consoleSixAxisSensorAngularVelocityTimeBias : (%f, %f, %f)\n"
            "consoleSixAxisSensorAngularAcceleration     : (%f, %f, %f, %f, %f, %f, %f, %f, %f)\n"
            // consoleSixAxisSensorAccelerationBias
            , consoleSixAxisSensorAccelerationBias.x
            , consoleSixAxisSensorAccelerationBias.y
            , consoleSixAxisSensorAccelerationBias.z
            // consoleSixAxisSensorAngularVelocityBias
            , consoleSixAxisSensorAngularVelocityBias.x
            , consoleSixAxisSensorAngularVelocityBias.y
            , consoleSixAxisSensorAngularVelocityBias.z
            // consoleSixAxisSensorAccelerationGain
            , consoleSixAxisSensorAccelerationGain.xx
            , consoleSixAxisSensorAccelerationGain.xy
            , consoleSixAxisSensorAccelerationGain.xz
            , consoleSixAxisSensorAccelerationGain.yx
            , consoleSixAxisSensorAccelerationGain.yy
            , consoleSixAxisSensorAccelerationGain.yz
            , consoleSixAxisSensorAccelerationGain.zx
            , consoleSixAxisSensorAccelerationGain.zy
            , consoleSixAxisSensorAccelerationGain.zz
            // consoleSixAxisSensorAngularVelocityGain
            , consoleSixAxisSensorAngularVelocityGain.xx
            , consoleSixAxisSensorAngularVelocityGain.xy
            , consoleSixAxisSensorAngularVelocityGain.xz
            , consoleSixAxisSensorAngularVelocityGain.yx
            , consoleSixAxisSensorAngularVelocityGain.yy
            , consoleSixAxisSensorAngularVelocityGain.yz
            , consoleSixAxisSensorAngularVelocityGain.zx
            , consoleSixAxisSensorAngularVelocityGain.zy
            , consoleSixAxisSensorAngularVelocityGain.zz
            // consoleSixAxisSensorAngularVelocityTimeBias
            , consoleSixAxisSensorAngularVelocityTimeBias.x
            , consoleSixAxisSensorAngularVelocityTimeBias.y
            , consoleSixAxisSensorAngularVelocityTimeBias.z
            // consoleSixAxisSensorAngularAcceleration
            , consoleSixAxisSensorAngularAcceleration.xx
            , consoleSixAxisSensorAngularAcceleration.xy
            , consoleSixAxisSensorAngularAcceleration.xz
            , consoleSixAxisSensorAngularAcceleration.yx
            , consoleSixAxisSensorAngularAcceleration.yy
            , consoleSixAxisSensorAngularAcceleration.yz
            , consoleSixAxisSensorAngularAcceleration.zx
            , consoleSixAxisSensorAngularAcceleration.zy
            , consoleSixAxisSensorAngularAcceleration.zz
        );
    }
};

}}} // namespace nn::hid::detail
