﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_Common.h>
#include <nn/hid/hid_ConsoleSixAxisSensor.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

#include "hid_ConsoleSixAxisSensorAppletSetting.h"
#include "hid_ConsoleSixAxisSensorAppletSettingManager.h"

namespace nn { namespace hid { namespace detail {

ConsoleSixAxisSensorAppletSettingManager::ConsoleSixAxisSensorAppletSettingManager() NN_NOEXCEPT
{
    m_EmptySetting.Reset(true);
}

ConsoleSixAxisSensorAppletSettingManager::~ConsoleSixAxisSensorAppletSettingManager() NN_NOEXCEPT
{
    // 何もしない
}

void ConsoleSixAxisSensorAppletSettingManager::SetAppletResourceManager(
    AppletResourceManager* pManager, ::nn::os::SdkRecursiveMutex* pMutex) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pManager);
    NN_SDK_REQUIRES_NOT_NULL(pMutex);
    m_pAppletResourceManager = pManager;
    m_pAppletResourceManagerMutex = pMutex;
}

Result ConsoleSixAxisSensorAppletSettingManager::GetConsoleSixAxisSensorSetting(
    ConsoleSixAxisSensorSetting** pOutSetting,
    ::nn::applet::AppletResourceUserId aruid,
    const ConsoleSixAxisSensorHandle& handle) NN_NOEXCEPT
{
    ConsoleSixAxisSensorAppletSetting* pSetting;
    {
        ::std::lock_guard<decltype(*m_pAppletResourceManagerMutex)
        > locker(*m_pAppletResourceManagerMutex);

        pSetting = m_pAppletResourceManager->GetConsoleSixAxisSensorAppletSetting(aruid);
    }

    if (pSetting == nullptr)
    {
        // 現在の Aruid に対応する設定値が見つからなかった場合はデフォルト設定を利用する
        *pOutSetting = &m_EmptySetting;
        NN_RESULT_SUCCESS;
    }

    *pOutSetting = pSetting->GetConsoleSixAxisSensorSetting(handle);
    NN_RESULT_SUCCESS;
}

ConsoleSixAxisSensorAppletSetting* ConsoleSixAxisSensorAppletSettingManager::GetFocusedSetting() NN_NOEXCEPT
{
    ConsoleSixAxisSensorAppletSetting* pSetting;
    {
        ::std::lock_guard<decltype(*m_pAppletResourceManagerMutex)
        > locker(*m_pAppletResourceManagerMutex);

        const ::nn::applet::AppletResourceUserId currentAruid =
            m_pAppletResourceManager->GetAppletResourceUserId();

        pSetting = m_pAppletResourceManager->GetConsoleSixAxisSensorAppletSetting(currentAruid);
    }

    return pSetting;
}

::nn::applet::AppletResourceUserId ConsoleSixAxisSensorAppletSettingManager::GetFocusedAppletResourceUserId() NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pAppletResourceManager);
    NN_SDK_REQUIRES_NOT_NULL(m_pAppletResourceManagerMutex);

    return m_pAppletResourceManager->GetAppletResourceUserId();
}

void ConsoleSixAxisSensorAppletSettingManager::GetAppletResourceUserId(::nn::applet::AppletResourceUserId* pOutValues,
                                                                       int count) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(m_pAppletResourceManager);
    NN_SDK_REQUIRES_NOT_NULL(m_pAppletResourceManagerMutex);
    m_pAppletResourceManager->GetAppletResourceUserId(pOutValues, count);
}

}}} // namespace nn::hid::detail
