﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid/system/hid_AnalogStickManualCalibration.h>

namespace nn { namespace hid { namespace detail {

const int AnalogStickPositionCountMax = 2;

inline system::AnalogStickPosition GetAnalogStickPositionFromIndex(int index)
{
    switch (index)
    {
    case 0:
        return system::AnalogStickPosition_Left;
    case 1:
        return system::AnalogStickPosition_Right;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

inline int GetIndexFromAnalogStickPosition(system::AnalogStickPosition position)
{
    switch (position)
    {
    case system::AnalogStickPosition_Left:
        return 0;
    case system::AnalogStickPosition_Right:
        return 1;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

// int から AnalogStickCalibrationStage に変換
template<typename T>
inline system::AnalogStickManualCalibrationStage GetAnalogStickCalibrationStageFromInt(T value)
{
    switch (value)
    {
    case system::AnalogStickManualCalibrationStage_Clear:
        return system::AnalogStickManualCalibrationStage_Clear;
    case system::AnalogStickManualCalibrationStage_ClearCompleted:
        return system::AnalogStickManualCalibrationStage_ClearCompleted;
    case system::AnalogStickManualCalibrationStage_Completed:
        return system::AnalogStickManualCalibrationStage_Completed;
    case system::AnalogStickManualCalibrationStage_ReleaseFromBottom:
        return system::AnalogStickManualCalibrationStage_ReleaseFromBottom;
    case system::AnalogStickManualCalibrationStage_ReleaseFromLeft:
        return system::AnalogStickManualCalibrationStage_ReleaseFromLeft;
    case system::AnalogStickManualCalibrationStage_ReleaseFromRight:
        return system::AnalogStickManualCalibrationStage_ReleaseFromRight;
    case system::AnalogStickManualCalibrationStage_ReleaseFromTop:
        return system::AnalogStickManualCalibrationStage_ReleaseFromTop;
    case system::AnalogStickManualCalibrationStage_Rotate:
        return system::AnalogStickManualCalibrationStage_Rotate;
    case system::AnalogStickManualCalibrationStage_Update:
        return system::AnalogStickManualCalibrationStage_Update;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}}} // namespace nn::hid::detail
