﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#include "hid_IAbstractedPad.h"
#include "hid_AbstractedPadIdPublisher.h"

namespace nn { namespace hid { namespace detail {

class AbstractedFiftyPad final : public IAbstractedPad
{
private:
    static const AbstractedPadType s_Type = AbstractedPadType_Fifty;

    //!< AbstractedId パブリッシャー
    AbstractedPadIdPublisher* m_pIdPublisher;

    //!< コントローラーの接続状態
    bool m_IsConnected;

    //!< コントローラーの入力状態
    AbstractedPadState m_PadState;

    //!< インジケーターパターン
    uint8_t m_Pattern;

public:
    AbstractedFiftyPad() NN_NOEXCEPT;
    virtual ~AbstractedFiftyPad() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの接続状態を取得する
    virtual bool IsConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedPadType を取得する
    virtual AbstractedPadType GetType() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスの電源状態を取得する
    virtual system::PowerInfo GetPowerInfo() NN_NOEXCEPT NN_OVERRIDE;

    //!< デバイスのボタン/アナログスティックの入力状態を取得する
    virtual AbstractedPadState GetPadState() NN_NOEXCEPT NN_OVERRIDE;

    //!< 最後にボタンが押下された時間を取得する
    virtual bool GetButtonTriggerElapsedTime(nn::os::Tick* pOutTick, AbstractedPadButtonSet button) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターを制御する
    virtual void SetIndicator(uint8_t pattern, bool blink) NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーのインジケーターパターンを取得する
    virtual uint8_t GetIndicator() NN_NOEXCEPT NN_OVERRIDE;

    //!< ケーブル接続されているかどうか
    virtual bool IsWired() NN_NOEXCEPT NN_OVERRIDE;

    //!< Usb の接続状態を取得します
    virtual bool IsUsbConnected() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを接続状態に変更します
    virtual void Connect() NN_NOEXCEPT NN_OVERRIDE;

    //!< コントローラーを切断する
    virtual void Detach() NN_NOEXCEPT NN_OVERRIDE;

    //!< バッテリーを搭載しているかどうか取得します
    virtual bool HasBattery() NN_NOEXCEPT NN_OVERRIDE;

    //!< プレイレポート用のデフォルトの情報を取得します。正しく読み出せた場合は true を返します。
    virtual bool SetDeviceInfoOnPlayReportControllerUsage(system::PlayReportControllerUsage* pOutValue) NN_NOEXCEPT NN_OVERRIDE;

    //!< AbstractedId パブリッシャーをセットします
    void SetAbstractedPadIdPublisher(AbstractedPadIdPublisher* pPublisher) NN_NOEXCEPT;

    //!< Fifty の内部状態を更新します。
    void Update() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
