﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/xcd/xcd_Device.h>

#include "hid_AbstractedAutoPilotVirtualPad.h"
#include "hid_ActivationCount.h"
#include "hid_MultiWaitEvent.h"

namespace nn { namespace hid { namespace detail {

//!< 自動入力の抽象化 Pad の最大数
const int AbstractedAutoPilotVirtualPadCount = 8;

//!< 自動入力の抽象化 Pad を管理するマネージャー
class AbstractedAutoPilotVirtualPadManager final
{
    NN_DISALLOW_COPY(AbstractedAutoPilotVirtualPadManager) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(AbstractedAutoPilotVirtualPadManager) NN_NOEXCEPT;

private:
    //!< AbstractedPad のリスト
    AbstractedAutoPilotVirtualPad* m_pPads[AbstractedAutoPilotVirtualPadCount];

    //!< AbstractedPad の数
    int m_PadCount;

public:
    AbstractedAutoPilotVirtualPadManager() NN_NOEXCEPT;

    ~AbstractedAutoPilotVirtualPadManager() NN_NOEXCEPT;

    //!< AbstractedAutoPilotVirtualPad をセットします
    void SetAbstractedAutoPilotVirtualPads(AbstractedAutoPilotVirtualPad* pPads, int count) NN_NOEXCEPT;

    //!< Npad に自動操作状態を設定します。
    ::nn::Result SetAutoPilotState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId,
        const ::nn::hid::debug::AbstractedPadState& value) NN_NOEXCEPT;

    //!< Npad の自動操作状態を解除します。
    ::nn::Result UnsetAutoPilotState(const ::nn::hid::debug::AbstractedVirtualPadId& virtualPadId) NN_NOEXCEPT;

    //!< 全ての Npad の自動操作状態を解除します。
    ::nn::Result UnsetAllAutoPilotState() NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
