﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/xcd/xcd_Device.h>

#include "hid_AbstractedAutoPilotPad.h"
#include "hid_ActivationCount.h"
#include "hid_MultiWaitEvent.h"

namespace nn { namespace hid { namespace detail {

//!< 自動入力の抽象化 Pad の最大数
const int AbstractedAutoPilotPadCount = 8;

//!< 自動入力の抽象化 Pad を管理するマネージャー
class AbstractedAutoPilotPadManager final
{
    NN_DISALLOW_COPY(AbstractedAutoPilotPadManager) NN_NOEXCEPT;
    NN_DISALLOW_MOVE(AbstractedAutoPilotPadManager) NN_NOEXCEPT;

private:
    //!< AbstractedPad のリスト
    AbstractedAutoPilotPad* m_pPads[AbstractedAutoPilotPadCount];

    //!< AbstractedPad の数
    int m_PadCount;

    //!< アクティブ化された回数
    ActivationCount m_ActivationCount;

public:
    AbstractedAutoPilotPadManager() NN_NOEXCEPT;

    ~AbstractedAutoPilotPadManager() NN_NOEXCEPT;

    //!< AbstractedAutoPilotPad をセットします
    void SetAbstractedAutoPilotPads(AbstractedAutoPilotPad* pPads, int count) NN_NOEXCEPT;

    //!< マネージャをアクティブ化します。
    ::nn::Result Activate() NN_NOEXCEPT;

    //!< マネージャを非アクティブ化します。
    ::nn::Result Deactivate() NN_NOEXCEPT;

    //!< Npad に自動操作状態を設定します。
    ::nn::Result SetAutoPilotState(int playerNumber,
        const ::nn::hid::debug::BasicXpadAutoPilotState& value) NN_NOEXCEPT;

    //!< Npad の自動操作状態を解除します。
    ::nn::Result UnsetAutoPilotState(int playerNumber) NN_NOEXCEPT;
};

}}} // namespace nn::hid::detail
