﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/helloworld/helloworld_GetString.h>
#include <nn/nn_SdkText.h>

namespace nn { namespace helloworld {

namespace
{
    // 文字列取得関数の戻り値となる定数文字列の定義です
    const char* EnglishGreeting  = "Hello, World!";
    const char* GermanGreeting   = "Hallo, Welt!";
    const char* FrenchGreeting   = "Bonjour Tout Le Monde!";
    const char* JapaneseGreeting = NN_TEXT("こんにちは、世界！");
}

const char* GetHelloWorldString()
{
    return EnglishGreeting;
}

const char* GetTranslatedHelloWorldString(Language language)
{
    switch ( language )
    {
    case Language::English:
        return EnglishGreeting;

    case Language::German:
        return GermanGreeting;

    case Language::French:
        return FrenchGreeting;

    case Language::Japanese:
        return JapaneseGreeting;

    default:
        return nullptr;
    }
}

}}
