﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nvnflinger_service.h>
#include "../../capsrv/capture/capsrv_CaptureModule.h"

namespace nn{ namespace grcsrv{ namespace offscreen{

    // src から dst へコピーします。
    // コピー範囲は src, dst ともに全面です。
    nn::Result VicCopyCaptureImageBuffer(
        android::sp<android::Fence>* pOutFence,
        const android::sp<android::GraphicBuffer>& dst,
        const android::sp<android::GraphicBuffer>& src,
        nn::capsrv::capture::CaptureModule* pModule
    ) NN_NOEXCEPT;

    // src から dst へコピーします。
    // src のコピー範囲は srcItem.mCrop です。
    // dst のコピー範囲は全面です。
    nn::Result VicCopyCaptureImageBuffer(
        android::sp<android::Fence>* pOutFence,
        const android::sp<android::GraphicBuffer>& dst,
        const android::sp<android::GraphicBuffer>& src,
        const android::IGraphicBufferConsumer::BufferItem& srcItem,
        nn::capsrv::capture::CaptureModule* pModule
    ) NN_NOEXCEPT;

}}}
