﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/capsrv/movie/capsrv_MovieWriterFileSystem.h>
#include <nn/capsrv/movie/capsrv_MovieMetaDataBuilder.h>

#include "grcsrvOffscreen_Layer.h"
#include "grcsrvOffscreen_CaptureImageBuffer.h"

namespace nn{ namespace grcsrv{ namespace offscreen{

    struct LibraryState
    {
    public:
        nn::Result InitializeCaptureModule() NN_NOEXCEPT;
        void FinalizeCaptureModule() NN_NOEXCEPT;

        nn::Result InitializeMovieFileSystem(void* memory, size_t size) NN_NOEXCEPT;
        void FinalizeMovieFileSystem() NN_NOEXCEPT;
        nn::Result AttachMovieFileData(nn::fs::FileHandle* pOutFileHandle, nn::capsrv::AlbumMovieWriteStreamHandle hStream) NN_NOEXCEPT;
        void DetachMovieFileData(nn::fs::FileHandle hFile) NN_NOEXCEPT;

        nn::Result InitializeMovieMeta(void* memory, size_t size) NN_NOEXCEPT;
        void FinalizeMovieMeta() NN_NOEXCEPT;

    public:
        nn::util::optional<Layer> m_Layer = nn::util::nullopt;
        nn::util::optional<nn::capsrv::AlbumFileId> m_FileId = nn::util::nullopt;                       // WriteStream のオープン中、有効な値を取る
        nn::util::optional<nn::capsrv::AlbumMovieWriteStreamHandle> m_StreamHandle = nn::util::nullopt; // WriteStream のオープン中、有効な値を取る
        nn::util::optional<nn::fs::FileHandle> m_FileHandle = nn::util::nullopt;                        // DataSection のアタッチ中、有効な値を取る
        int32_t m_BinderHandle = 1;

        nn::capsrv::capture::CaptureModule* m_pCaptureModule;

        CaptureImageBuffer m_ImageBuffer;

        struct {
            nn::capsrv::movie::MovieWriterFileSystem m_FileSystem;
            void*  m_pMemory;
            size_t m_MemorySize;
            nn::util::optional<nn::capsrv::AlbumMovieWriteStreamHandle> m_AttachedStreamHandle;
        } m_MovieFileSystem;

        struct {
            nn::capsrv::movie::MovieMetaDataBuilder m_Builder;
            void*  m_pMemory;
            size_t m_MemorySize;
        } m_MovieMeta;

    };

}}}
