﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/grcsrv/grcsrv_GrcServices.sfdl.h>

#include <nn/os/os_Thread.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_ConditionVariable.h>

namespace nn { namespace grcsrv { namespace detail {

class SubTaskThread
{
private:

    bool m_IsThreadCreated = false;
    os::ThreadType m_Thread;
    mutable os::Mutex m_Mutex{false};
    os::ConditionVariable m_Cv;
    bool m_IsRequesting;
    bool m_IsThreadExitRequesting;
    bool m_IsRunning = false;
    os::SystemEvent m_NotRunningEvent{os::EventClearMode_ManualClear, true};

    virtual void DoTask() NN_NOEXCEPT = 0;
    virtual void DoCancel() NN_NOEXCEPT = 0;

    void DoTaskImpl() NN_NOEXCEPT;
    void RequestThreadExitImpl() NN_NOEXCEPT;

public:

    Result StartThread(void* stack, size_t stackSize, int priority, const char* name) NN_NOEXCEPT;
    void StopThread() NN_NOEXCEPT;

    Result Start(void (*onStart)(void* p) = nullptr, void* p = nullptr) NN_NOEXCEPT;
    template <typename F>
    Result Start(F&& f) NN_NOEXCEPT
    {
        return Start([](void* p)
        {
            (*static_cast<F*>(p))();
        }, static_cast<void*>(&f));
    }

    Result Cancel() NN_NOEXCEPT;
    Result GetNotRunningEvent(sf::Out<sf::NativeHandle> pOutSystemEventHandle) NN_NOEXCEPT;
    bool IsRunning() const NN_NOEXCEPT;

};

}}}
