﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_ResShader.h>
#include <nn/gfx/gfx_Shader.h>
#include <nn/gfx/gfx_Device.h>
#include <nn/gfx/gfx_CommandBuffer.h>

namespace nn {
namespace gfx {

size_t ResShaderFile::GetMaxFileAlignment() NN_NOEXCEPT
{
    return 4 * 1024;
}

bool ResShaderFile::IsValid( const void* ptr ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( ptr );

    const nn::util::BinaryFileHeader* pFileHeader =
        static_cast< const nn::util::BinaryFileHeader* >( ptr );

    return pFileHeader->IsValid( Signature, MajorVersion, MinorVersion, MicroVersion );
}

ResShaderFile* ResShaderFile::ResCast( void* ptr ) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( ptr );

    ResShaderFile::value_type* pData = static_cast< ResShaderFile::value_type* >( ptr );
    ResShaderFile* pRet = ToAccessor( pData );

    NN_SDK_ASSERT( pRet->fileHeader.IsValid( Signature, MajorVersion, MinorVersion, MicroVersion ) );

    // TODO: エンディアン

    if( !pRet->fileHeader.IsRelocated() )
    {
        pRet->fileHeader.GetRelocationTable()->Relocate();
    }

    NN_SDK_ASSERT( pRet->GetShaderContainer() );
    NN_SDK_ASSERT( pRet->GetShaderContainer()->ToData(
        ).blockHeader.signature.IsValid( ResShaderContainer::Signature ) );

    return pRet;
}

NN_STATIC_ASSERT( sizeof( ResShaderProgramData ) == 160 );
NN_STATIC_ASSERT( sizeof( ResShaderVariationData ) == 64 );
NN_STATIC_ASSERT( sizeof( ResShaderContainerData ) == 96 );
NN_STATIC_ASSERT( sizeof( ResShaderFileData ) == 96 );
NN_STATIC_ASSERT( sizeof( ResShaderReflectionStageData ) == 96 );
NN_STATIC_ASSERT( sizeof( ResShaderReflectionData ) == 64 );

}
}
