﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <d3d11_1.h>
#include <d3dcompiler.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/gfx/gfx_Enum.h>
#include <nn/gfx/gfx_Variation-api.d3d.h>
#include <nn/gfx/gfx_DeviceInfo.h>

#include <nn/gfx/detail/gfx_Common-api.d3d.h>
#include <nn/gfx/detail/gfx_Declare.h>
#include <nn/gfx/detail/gfx_Misc.h>

#define NN_GFX_CALL_D3D_FUNCTION( func ) ( func )

namespace nn {
namespace gfx {
namespace detail {

struct D3dTextureFormat
{
    DXGI_FORMAT dxgiFormat;
};

struct D3dAttributeFormat
{
    DXGI_FORMAT dxgiFormat;
};

struct D3dIndexFormat
{
    DXGI_FORMAT dxgiFormat;
};

class D3d
{
public:
    static void CreateDevice( ID3D11Device** ppOutDevice,
        ID3D11DeviceContext** ppOutDeviceContext, bool debugMode ) NN_NOEXCEPT;

    static void DeleteDevice( ID3D11Device* pDevice,
        ID3D11DeviceContext* pDeviceContext ) NN_NOEXCEPT;

    static void CreateSwapChain( IDXGISwapChain** ppSwapChain, int width, int height,
        ImageFormat imageFormat, int bufferCount, ID3D11Device* pDevice, HWND hWnd ) NN_NOEXCEPT;

    static D3dTextureFormat GetTextureFormat( ImageFormat format ) NN_NOEXCEPT;

    static D3dTextureFormat GetShaderResourceTextureFormat( ImageFormat format ) NN_NOEXCEPT;

    static D3dTextureFormat GetShaderResourceTextureViewFormat(
        ImageFormat format, DepthStencilFetchMode depthStencilFetchMode ) NN_NOEXCEPT;

    static int GetBindFlag( int gpuAccessFlags ) NN_NOEXCEPT;

    static size_t GetImageSize( ImageFormat imageFormat,
        int width, int height, int depth ) NN_NOEXCEPT;

    static D3D11_FILL_MODE GetFillMode( FillMode fillMode ) NN_NOEXCEPT;

    static D3D11_CULL_MODE GetCullMode( CullMode cullMode ) NN_NOEXCEPT;

    static D3D11_BLEND GetBlendFactor( BlendFactor blendFactor ) NN_NOEXCEPT;

    static D3D11_BLEND_OP GetBlendOperation( BlendFunction blendFunction ) NN_NOEXCEPT;

    static int GetChannelMask( int channelMask ) NN_NOEXCEPT;

    static D3D11_PRIMITIVE_TOPOLOGY GetPrimitiveTopology(
        PrimitiveTopology primitiveTopology, int patchCount ) NN_NOEXCEPT;

    static D3D11_COMPARISON_FUNC GetComparisonFunction(
        ComparisonFunction comparisonFunction ) NN_NOEXCEPT;

    static D3D11_STENCIL_OP GetStencilOperation( StencilOperation stencilOperation ) NN_NOEXCEPT;

    static D3dAttributeFormat GetAttributeFormat( AttributeFormat format ) NN_NOEXCEPT;

    static D3dIndexFormat GetIndexFormat( IndexFormat format ) NN_NOEXCEPT;

    static int GetDepthStencilClearMode( DepthStencilClearMode clearMode ) NN_NOEXCEPT;

    static D3D11_FILTER GetFilterMode( FilterMode filterMode ) NN_NOEXCEPT;

    static D3D11_TEXTURE_ADDRESS_MODE GetTextureAddressMode(
        TextureAddressMode textureAddressMode ) NN_NOEXCEPT;

    static ImageDimension GetImageDimension( ID3D11Resource* pResource ) NN_NOEXCEPT;

    static int GetTextureMipLevels( ID3D11Resource* pResource ) NN_NOEXCEPT;

    static void GetTextureSize( int* pWidth, int* pHeight, int* pDepth,
        ID3D11Resource* pResource ) NN_NOEXCEPT;

    static ID3D11Buffer* GetBufferResource( uint64_t bufferAddressImpl ) NN_NOEXCEPT;

    static ID3D11UnorderedAccessView* GetBufferResourceView(
        uint64_t bufferAddressImpl ) NN_NOEXCEPT;
};


}
}
}
