﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_Variation-api.vk.h>

#include <nn/gfx/detail/gfx_BufferLayout-api.vk.1.h>

#include "gfx_VkHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationVk1 Target;

int64_t TimestampBufferImpl< Target >::GetValue() const NN_NOEXCEPT
{
    return this->value;
}

int64_t QueryBufferImpl< Target >::GetValue() const NN_NOEXCEPT
{
    return this->value;
}

int64_t GraphicsPipelineStatisticsQueriesBufferImpl< Target >::GetValue( QueryTarget target ) const NN_NOEXCEPT
{
    NN_SDK_ASSERT( target != QueryTarget_Timestamp && target != QueryTarget_SamplesPassed &&
        target != QueryTarget_ComputeShaderInvocations );

    switch ( target )
    {
    case QueryTarget_InputVertices:
    case QueryTarget_InputPrimitives:
    case QueryTarget_VertexShaderInvocations:
    case QueryTarget_GeometryShaderInvocations:
    case QueryTarget_GeometryShaderPrimitives:
    case QueryTarget_ClippingInputPrimitives:
    case QueryTarget_ClippingOutputPrimitives:
    case QueryTarget_PixelShaderInvocations:
    case QueryTarget_HullShaderInvocations:
    case QueryTarget_DomainShaderInvocations:
        {
            return this->value[ target - QueryTarget_InputVertices ];
        }
    default:
        {
            return 0;
        }
    }
}

template<>
nn::TimeSpan GetDuration< Target >(
    int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT
{
    return Vk::ToTimeSpan( endTimestampValue - startTimestampValue );
}

}
}
}
