﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/gfx/gfx_Variation-api.nvn.h>

#include <nn/gfx/detail/gfx_BufferLayout-api.nvn.8.h>

#include "gfx_NvnHelper.h"

namespace nn {
namespace gfx {
namespace detail {

typedef ApiVariationNvn8 Target;

int64_t TimestampBufferImpl< Target >::GetValue() const NN_NOEXCEPT
{
    return this->value;
}

int64_t QueryBufferImpl< Target >::GetValue() const NN_NOEXCEPT
{
    return this->value;
}

template<>
nn::TimeSpan GetDuration< Target >(
    int64_t startTimestampValue, int64_t endTimestampValue ) NN_NOEXCEPT
{
    return Nvn::ToTimeSpan( endTimestampValue - startTimestampValue );
}

}
}
}
