﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/ens_Types.h>
#include <nn/nn_SdkAssert.h>
#include <nn/util/util_FormatString.h>

namespace nn { namespace ens {

namespace
{
    // 16 進数文字列を数値に変換する。
    int ConvertHexDigitToInteger(char c) NN_NOEXCEPT
    {
        if (c >= '0' && c <= '9')
        {
            return c - '0';
        }
        if (c >= 'a' && c <= 'f')
        {
            return c - 'a' + 10;
        }
        if (c >= 'A' && c <= 'F')
        {
            return c - 'A' + 10;
        }

        return -1;
    }
}

const char* Digest::ToString(char* pOut, size_t size) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOut);
    NN_SDK_ASSERT_GREATER(size, StringLength);

    nn::util::SNPrintf(pOut, size,
        "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
        value[0], value[1], value[2], value[3], value[4],
        value[5], value[6], value[7], value[8], value[9],
        value[10], value[11], value[12], value[13], value[14],
        value[15], value[16], value[17], value[18], value[19]);

    return pOut;
}

bool Digest::FromString(Digest* pOut, const char* pValue) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOut);
    NN_SDK_ASSERT_NOT_NULL(pValue);

    for (int i = 0; i < Size; i++)
    {
        int valueH = ConvertHexDigitToInteger(pValue[0]);

        // 途中で 0-9a-fA-F 以外（NULL 終端含む）を検知したらエラーにする。
        if (valueH == -1)
        {
            return false;
        }

        int valueL = ConvertHexDigitToInteger(pValue[1]);

        if (valueL == -1)
        {
            return false;
        }

        pOut->value[i] = (static_cast<nn::Bit8>(valueH) << 4) | (static_cast<nn::Bit8>(valueL));

        pValue += 2;
    }

    return true;
}

}}
