﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/ens_SimpleMessagePackReader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nn { namespace ens {

SimpleMessagePackReader::SimpleMessagePackReader(const void* pData, size_t size) NN_NOEXCEPT
    : m_pData(reinterpret_cast<const nn::Bit8*>(pData))
    , m_Size(size)
{
    NN_SDK_REQUIRES_NOT_NULL(pData);
    NN_SDK_ASSERT_GREATER(size, 0u);
}

bool SimpleMessagePackReader::Get(bool* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(int8_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(int16_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(int32_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(int64_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(uint8_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(uint16_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(uint32_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(uint64_t* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(double* pOutValue, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(char* pOutValue, size_t size, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_GREATER(size, 0u);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutValue, size);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::Get(size_t* pOutSize, void* pOutValue, size_t size, const char* pPath) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutSize);
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_GREATER(size, 0u);
    NN_SDK_REQUIRES_NOT_NULL(pPath);

    detail::util::ResponseStructureReader<1> reader;

    reader.Add(pPath, pOutSize, pOutValue, size);

    NN_DETAIL_ENS_RETURN_IF_FALSE(reader.Read<detail::util::MessagePackReader>(m_pData, m_Size));

    return true;
}

bool SimpleMessagePackReader::IsValid() const NN_NOEXCEPT
{
    detail::util::MessagePackReader reader;

    return reader.Read(m_pData, m_Size);
}

}}
