﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/ens_ServiceThreadContext.h>

namespace nn { namespace ens {

ServiceThreadContext::ServiceThreadContext() NN_NOEXCEPT
    : m_StopEvent(nn::os::EventClearMode_ManualClear)
    , m_StartedEvent(nn::os::EventClearMode_ManualClear)
    , m_StoppedEvent(nn::os::EventClearMode_ManualClear)
    , m_pThread(nullptr)
    , m_pBuffer(nullptr)
    , m_BufferSize(0)
{
}

ServiceThreadContext::~ServiceThreadContext() NN_NOEXCEPT
{
}

void ServiceThreadContext::SetBuffer(void* pBuffer, size_t bufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pBuffer);
    NN_SDK_REQUIRES_GREATER(bufferSize, 0u);

    m_pBuffer = pBuffer;
    m_BufferSize = bufferSize;
}

nn::os::Event& ServiceThreadContext::GetStopEvent() NN_NOEXCEPT
{
    return m_StopEvent;
}

nn::os::Event& ServiceThreadContext::GetStartedEvent() NN_NOEXCEPT
{
    return m_StartedEvent;
}

nn::os::Event& ServiceThreadContext::GetStoppedEvent() NN_NOEXCEPT
{
    return m_StoppedEvent;
}

void ServiceThreadContext::SetThread(nn::os::ThreadType* pThread) NN_NOEXCEPT
{
    m_pThread = pThread;
}

nn::os::ThreadType* ServiceThreadContext::GetThread() const NN_NOEXCEPT
{
    return m_pThread;
}

void* ServiceThreadContext::GetBuffer() NN_NOEXCEPT
{
    return m_pBuffer;
}

size_t ServiceThreadContext::GetBufferSize() const NN_NOEXCEPT
{
    return m_BufferSize;
}

}}
