﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/util/ens_DataHolder.h>

namespace nn { namespace ens { namespace detail { namespace util {

bool DataHolder::Get(bool* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Boolean)
    {
        return false;
    }

    *pOutValue = boolean;

    return true;
}

bool DataHolder::Get(int8_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int8_t>(integer.s64));

        *pOutValue = static_cast<int8_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int8_t>(integer.u64));

        *pOutValue = static_cast<int8_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(int16_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int16_t>(integer.s64));

        *pOutValue = static_cast<int16_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int16_t>(integer.u64));

        *pOutValue = static_cast<int16_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(int32_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int32_t>(integer.s64));

        *pOutValue = static_cast<int32_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int32_t>(integer.u64));

        *pOutValue = static_cast<int32_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(int64_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        *pOutValue = integer.s64;
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<int64_t>(integer.u64));

        *pOutValue = static_cast<int64_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(uint8_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint8_t>(integer.s64));

        *pOutValue = static_cast<uint8_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint8_t>(integer.u64));

        *pOutValue = static_cast<uint8_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(uint16_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint16_t>(integer.s64));

        *pOutValue = static_cast<uint16_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint16_t>(integer.u64));

        *pOutValue = static_cast<uint16_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(uint32_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint32_t>(integer.s64));

        *pOutValue = static_cast<uint32_t>(integer.s64);
    }
    else
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint32_t>(integer.u64));

        *pOutValue = static_cast<uint32_t>(integer.u64);
    }

    return true;
}

bool DataHolder::Get(uint64_t* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Integer)
    {
        return false;
    }

    if (integer.isSigned)
    {
        NN_DETAIL_ENS_RETURN_IF_FALSE(nn::util::IsIntValueRepresentable<uint64_t>(integer.s64));

        *pOutValue = static_cast<uint64_t>(integer.s64);
    }
    else
    {
        *pOutValue = integer.u64;
    }

    return true;
}

bool DataHolder::Get(double* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    if (type != DataHolderType_Float)
    {
        return false;
    }

    *pOutValue = float64;

    return true;
}

bool DataHolder::Get(char* pOutValue, size_t size) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_GREATER(size, 0u);

    if (type != DataHolderType_String)
    {
        return false;
    }
    if (size <= string.length)
    {
        return false;
    }

    nn::util::Strlcpy(pOutValue, string.pValue, static_cast<int>(string.length + 1));

    return true;
}

bool DataHolder::Get(size_t* pOutSize, void* pOutValue, size_t size) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutSize);
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);
    NN_SDK_REQUIRES_GREATER(size, 0u);

    if (type != DataHolderType_Binary)
    {
        return false;
    }
    if (size < binary.length)
    {
        return false;
    }

    if (binary.length > 0)
    {
        std::memcpy(pOutValue, binary.pValue, binary.length);
    }

    *pOutSize = binary.length;

    return true;
}

bool DataHolder::Get(ReceiveBuffer* pOutValue) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutValue);

    return Get(&pOutValue->receivedSize, pOutValue->pBuffer, pOutValue->bufferSize);
}

}}}}
