﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/app/acbaa/task/ens_TaskReceiveMessageBody.h>
#include <nn/ens/detail/core/ens_HttpRequestHeader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_MessagePackWriter.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

TaskReceiveMessageBody::TaskReceiveMessageBody() NN_NOEXCEPT
    : m_pOutBody(nullptr)
    , m_MessageId(InvalidMessageId)
{
}

TaskReceiveMessageBody::~TaskReceiveMessageBody() NN_NOEXCEPT
{
}

void TaskReceiveMessageBody::SetParameter(ReceiveBuffer* pOutBody, const MessageId& messageId) NN_NOEXCEPT
{
    m_pOutBody = pOutBody;
    m_MessageId = messageId;
}

nn::Result TaskReceiveMessageBody::ExecuteSteps() NN_NOEXCEPT
{
    NN_RESULT_DO(StepReceive());

    NN_RESULT_SUCCESS;
}

nn::Result TaskReceiveMessageBody::StepReceive() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/message_cards/%llu", m_MessageId.value);

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "GET"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    detail::core::HttpRequestHeader header;

    NN_RESULT_DO(header.Add("Authorization", "Bearer %s", GetAuthToken().value));
    NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    // 出力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), ResultInvalidState());

        detail::util::ResponseStructureReader<2> reader;

        MessageId messageId = {};

        reader.Add("$.id",
            &messageId.value);
        reader.Add("$.body",
            m_pOutBody);

        NN_RESULT_THROW_UNLESS(reader.Read<detail::util::MessagePackReader>(GetResponse(), GetResponseSize()), ResultInvalidResponse());

        NN_RESULT_THROW_UNLESS(messageId == m_MessageId, ResultInvalidResponse());
    }

    NN_RESULT_SUCCESS;
}

}}}}}
