﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ens/detail/app/acbaa/task/ens_TaskDeleteMessage.h>
#include <nn/ens/detail/core/ens_HttpRequestHeader.h>
#include <nn/ens/detail/util/ens_MessagePackReader.h>
#include <nn/ens/detail/util/ens_MessagePackWriter.h>
#include <nn/ens/detail/util/ens_ResponseStructureReader.h>

namespace nn { namespace ens { namespace detail { namespace app_acbaa { namespace task {

TaskDeleteMessage::TaskDeleteMessage() NN_NOEXCEPT
    : m_pMessageIdList(nullptr)
    , m_Count(0)
    , m_pReason(nullptr)
{
}

TaskDeleteMessage::~TaskDeleteMessage() NN_NOEXCEPT
{
}

void TaskDeleteMessage::SetParameter(const MessageId* pMessageIdList, int count, const char* pReason) NN_NOEXCEPT
{
    m_pMessageIdList = pMessageIdList;
    m_Count = count;

    m_pReason = pReason;
}

nn::Result TaskDeleteMessage::ExecuteSteps() NN_NOEXCEPT
{
    NN_RESULT_DO(StepDelete());

    NN_RESULT_SUCCESS;
}

nn::Result TaskDeleteMessage::StepDelete() NN_NOEXCEPT
{
    NN_DETAIL_ENS_SCOPED_ACQUIRE_HTTP_CONNECTION(pCurl);

    char url[256] = {};
    detail::core::MakeUrl(url, sizeof (url), "api", "/api/v1/message_cards/delete");

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_CUSTOMREQUEST, "POST"));
    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_URL, url));

    detail::core::HttpRequestHeader header;

    // 入力パラメータへのアクセス
    {
        NN_UTIL_LOCK_GUARD(GetParameterLock());

        NN_RESULT_THROW_UNLESS(IsAsyncContextRegistered(), ResultInvalidState());

        detail::util::MessagePackWriter writer;

        writer.SetBuffer(GetRequestBuffer(), GetRequestBufferSize());

        NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteMap(2));
        {
            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteKey("id_list"));
            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteArray(m_Count));
            for (int i = 0; i < m_Count; i++)
            {
                NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteValue(m_pMessageIdList[i].value));
            }

            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteKey("reason"));
            NN_DETAIL_ENS_REQUEST_WRITER_DO(writer.WriteValue(m_pReason));
        }

        NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_POSTFIELDS, writer.GetBuffer()));
        NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_POSTFIELDSIZE, writer.GetWrittenSize()));
    }

    NN_RESULT_DO(header.Add("Authorization", "Bearer %s", GetAuthToken().value));
    NN_RESULT_DO(header.Add("Content-Type", "application/x-msgpack"));

    NN_DETAIL_ENS_CURL_EASY_DO(curl_easy_setopt(pCurl, CURLOPT_HTTPHEADER, header.Get()));

    NN_RESULT_DO(Perform());

    NN_DETAIL_ENS_DUMP_RESPONSE(detail::util::MessagePackReader, GetResponse(), GetResponseSize());

    NN_RESULT_SUCCESS;
}

}}}}}
