#----------------------------------------------------------------------------
# Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.
#
# These coded instructions, statements, and computer programs contain
# proprietary information of Nintendo of America Inc. and/or Nintendo
# Company Ltd., and are protected by Federal copyright law.  They may
# not be disclosed to third parties or copied or duplicated in any form,
# in whole or in part, without the prior written consent of Nintendo.
#----------------------------------------------------------------------------

LOCAL_PATH := $(call my-dir)

include $(CLEAR_VARS)

LOCAL_MODULE    := eft
ifeq ($(NW_BUILD), Debug)
LOCAL_CFLAGS    := -DNW_DEBUG -DEFT_OPENGLES2 -DNW_PLATFORM_SMART_DEVICE -std=c++11
else
ifeq ($(NW_BUILD), Release)
LOCAL_CFLAGS    := -DNW_RELEASE -DEFT_OPENGLES2 -DNW_PLATFORM_SMART_DEVICE -std=c++11
else
LOCAL_CFLAGS    := -DNW_DEVELOP -DEFT_OPENGLES2 -DNW_PLATFORM_SMART_DEVICE -std=c++11
endif
endif

LOCAL_SRC_FILES     :=  ../eft2_AreaLoop.cpp \
                        ../eft2_AreaLoop.cpp \
                        ../eft2_Callback.cpp \
                        ../eft2_CallbackPtclCalcArg.cpp \
                        ../eft2_CurlNoiseData.cpp \
                        ../eft2_Emitter.cpp \
                        ../eft2_EmitterCalc.cpp \
                        ../eft2_EmitterDraw.cpp \
                        ../eft2_EmitterEmit.cpp \
                        ../eft2_EmitterSet.cpp \
                        ../eft2_EmitterVolume.cpp \
                        ../eft2_FieldRandom.cpp \
                        ../eft2_KeyFrameAnim.cpp \
                        ../eft2_Misc.cpp \
                        ../eft2_ParticleBehavior.cpp \
                        ../eft2_Random.cpp \
                        ../eft2_Render.cpp \
                        ../eft2_RenderContext.cpp \
                        ../eft2_Resource.cpp \
                        ../eft2_Shader.cpp \
                        ../eft2_ShaderKey.cpp \
                        ../eft2_ShaderManager.cpp \
                        ../eft2_ShaderRes.cpp \
                        ../eft2_StreamOutBuffer.cpp \
                        ../eft2_Stripe.cpp \
                        ../eft2_StripeConnection.cpp \
                        ../eft2_SuperStripe.cpp \
                        ../eft2_System.cpp \
                        ../eft2_TemporaryBuffer.cpp \
                        ../eft2_Texture.cpp \
                        ../eft2_TextureSampler.cpp \
                        ../eft2_UniformBlock.cpp \
                        ../eft2_VertexBuffer.cpp \
                        ../../Sys/math/math_Arithmetic.cpp \
                        ../../Sys/math/math_Constant.cpp \
                        ../../Sys/math/math_Equation.cpp \
                        ../../Sys/math/math_Geometry.cpp \
                        ../../Sys/math/math_Matrix22.cpp \
                        ../../Sys/math/math_Matrix23.cpp \
                        ../../Sys/math/math_Matrix33.cpp \
                        ../../Sys/math/math_Matrix34.cpp \
                        ../../Sys/math/math_Matrix43.cpp \
                        ../../Sys/math/math_Matrix44.cpp \
                        ../../Sys/math/math_Quaternion.cpp \
                        ../../Sys/math/math_Transform.cpp  \
                        ../../Sys/math/math_Triangular.cpp \
                        ../../Sys/math/math_Types.cpp   \
                        ../../Sys/math/math_Vector2.cpp \
                        ../../Sys/math/math_Vector3.cpp \
                        ../../Sys/math/math_Vector4.cpp \

LOCAL_C_INCLUDES        := ../Include/
LOCAL_STATIC_LIBRARIES  := android_native_app_glue

include $(BUILD_STATIC_LIBRARY)

$(call import-module,android/native_app_glue)
