﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    class ScreenShotSequenceManager
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // seqNo 以下の撮影要求をキャンセルする。
        // スレッド安全。
        void RequestCancelSequence(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;

        // 強制的にキャンセル状態を書き換えます。
        // スレッド安全。
        void SetCancelState(uint64_t seqNo, nn::Result reason) NN_NOEXCEPT;

        // キャンセル要求が出ている seqNo を取得する。
        // スレッド安全。
        void GetCanceledSequenceNumber(uint64_t* pOutSeqNo, nn::Result* pOutReason) NN_NOEXCEPT;


    private:
        nn::os::SdkMutexType m_Mutex;
        uint64_t   m_CanceledSequenceNumber;
        nn::Result m_CancelReason;
    };

}}}}
