﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_RawScreenShotReadStream.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_ScreenShotContext.h"
#include "action/visrv_AcquireDisplayCaptureRgba.h"
#include "action/visrv_CopyDisplayCaptureRgbaToMemoryPartial.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    nn::Result OpenRawScreenShotReadStream(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_RESULT_DO(action::AcquireDisplayCaptureRgba(context));

        context.MarkSuspendRequired(ScreenShotContextSuspendedTask_RawScreenShotReadStream);

        NN_RESULT_SUCCESS;
    }

    nn::Result CloseRawScreenShotReadStream(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(context.GetSuspendedTask() == ScreenShotContextSuspendedTask_RawScreenShotReadStream, ResultScreenShotCaptureFailed());
        action::ReleaseDisplayCaptureRgba(context);

        context.UnmarkSuspendRequired();

        NN_RESULT_SUCCESS;
    }

    nn::Result ReadRawScreenShotReadStream(size_t* pOutReadSize, void* pBuffer, size_t bufferSize, ptrdiff_t offset, ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(context.GetSuspendedTask() == ScreenShotContextSuspendedTask_RawScreenShotReadStream, ResultScreenShotCaptureFailed());

        NN_RESULT_DO(action::CopyDisplayCaptureRgbaToMemoryPartial(pOutReadSize, pBuffer, bufferSize, offset, context));

        NN_RESULT_SUCCESS;
    }


}}}}
