﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_CreateProtoMovieMetaDataRgba.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "../capsrvServer_Config.h"
#include "action/visrv_DownsampleRgbaForViewerThumbnail.h"
#include "action/visrv_EncodeViewerThumbnailJpeg.h"
#include "action/visrv_CreateExifBuilder.h"
#include "action/visrv_EncodeScreenShotJpegRgba.h"
#include "action/visrv_CalculateMakerNoteRange.h"
#if defined(NN_CAPSRV_DEBUG_SAVE_MOVIE_META_DATA_AS_SCREENSHOT)
#include "action/visrv_SaveScreenShotFile.h"
#endif

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{

    nn::Result CreateProtoMovieMetaDataRgba(ScreenShotContext& context) NN_NOEXCEPT
    {
        // PhotoViewer 用サムネイルを作成
        NN_RESULT_DO(action::DownsampleRgbaForViewerThumbnail(context));
        NN_RESULT_DO(action::EncodeViewerThumbnailJpeg(context));

        // Jpeg データ作成
        {
            NN_RESULT_DO(action::CreateExifBuilder(context));
            NN_UTIL_SCOPE_EXIT{ action::DestroyExifBuilder(context); }; // エンコードしたら破棄する

            NN_RESULT_DO(action::EncodeScreenShotJpegRgba(context));
        }

        NN_RESULT_DO(action::CalculateMakerNoteRange(context));

        NN_RESULT_SUCCESS;
    }

}}}}
