﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_AlbumControl.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // AlbumFileId を生成する
    // @param[in]  context.ApplicationId
    // @param[in]  context.ContentsType
    // @param[out] context.AlbumFileId
    static nn::Result GenerateAlbumFileId(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ApplicationId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ContentsType);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, AlbumFileId);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("fileId    ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(appId, context, ApplicationId);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(contents, context, ContentsType);

        AlbumFileId fileId = {};
        NN_RESULT_DO(nn::capsrv::GenerateCurrentAlbumFileId(&fileId, appId, contents));

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, AlbumFileId, fileId);
        NN_RESULT_SUCCESS;
    }

}}}}}
