﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include <nn/capsrv/capsrv_AlbumFileSizeLimit.h>
#include "../../capsrvServer_Config.h"
#include "../visrv_ScreenShotUtility.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // 画面写真を JPEG エンコードする
    // @param[in]  context.RawDisplayCaptureRgbaMemory
    // @param[in]  context.ExifBuilder
    // @param[out] context.FileDataMemory
    // @param[out] context.FileSize
    // @param      context.EncoderWorkMemory
    static nn::Result EncodeScreenShotJpegRgba(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, ExifBuilder);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, RawDisplayCaptureRgbaMemory, 4 * ScreenShotWidth * ScreenShotHeight);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, FileDataMemory, AlbumFileSizeLimit_ScreenShot);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, EncoderWorkMemory, SoftwareJpegEncoderWorkMemorySize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OVERWRITEABLE(context, FileSize);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("encodeRgb ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pRawData, rawDataSize, context, RawDisplayCaptureRgbaMemory);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pEncodedBuffer, encodedBufferSize, context, FileDataMemory);
        std::memset(pEncodedBuffer, 0, encodedBufferSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pWork, workSize, context, EncoderWorkMemory);
        std::memset(pWork, 0, workSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(pExifBuilder, context, ExifBuilder);

        size_t rawSize = 4 * ScreenShotWidth * ScreenShotHeight;
        size_t encodedSize = 0;

        jpeg::SoftwareJpegEncoderBufferInputInfoRgba8 inputInfo = {};
        inputInfo.width      = ScreenShotWidth;
        inputInfo.height     = ScreenShotHeight;
        inputInfo.pImageData = pRawData;
        inputInfo.imageSize  = (rawDataSize < rawSize ? rawDataSize : rawSize);

        jpeg::SoftwareJpegEncoderBufferOutputInfo outputInfo = {};
        outputInfo.pOutSize   = &encodedSize;
        outputInfo.pBuffer    = pEncodedBuffer;
        outputInfo.bufferSize = (encodedBufferSize < AlbumFileSizeLimit_ScreenShot) ? encodedBufferSize : AlbumFileSizeLimit_ScreenShot;

        NN_RESULT_DO(ScreenShotUtility::EncodeRgba8BufferToBuffer(outputInfo, inputInfo, pExifBuilder, pWork, workSize));
        NN_ABORT_UNLESS_GREATER_EQUAL(encodedBufferSize, encodedSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_OVERWRITE(context, FileSize, encodedSize);
        NN_RESULT_SUCCESS;
    }
}}}}}
