﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>
#include <nn/capsrv/capsrv_AlbumFileSizeLimit.h>
#include "../visrv_ScreenShotContext.h"
#include "visrv_ActionTimeMeasure.h"

#include "../../detail/capsrvServer_ExtractJpegMakerNoteRange.h"

namespace nn{ namespace capsrv{ namespace server{ namespace screenshot{ namespace action{

    // 署名領域を計算して書き込む
    // @param[in]  context.FileDataMemory
    // @param[in]  context.FileDataSize
    // @param[out] context.MakerNoteOffset
    // @param[out] context.MakerNoteSize
    static nn::Result CalculateMakerNoteRange(ScreenShotContext& context) NN_NOEXCEPT
    {
        NN_CAPSRV_SCREENSHOT_CONTEXT_SCOPE(context);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_IN(context, FileSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, MakerNoteOffset);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_OUT(context, MakerNoteSize);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, FileDataMemory, AlbumFileSizeLimit_ScreenShot);
        NN_CAPSRV_SCREENSHOT_CONTEXT_REQUIRES_MEMORY(context, ExifMemory, ScreenShotExifWorkSize);

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET(fileSize, context, FileSize);
        NN_SDK_REQUIRES_GREATER(fileSize, 0);
        //NN_SDK_REQUIRES(context.GetExifBuilder() == nullptr);

        NN_CAPSRV_SCREENSHOT_ACTION_TIMEMEASURE("makernote ");

        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pFileData, fileBufferSize, context, FileDataMemory);
        NN_CAPSRV_SCREENSHOT_CONTEXT_GET_MEMORY(pExifMemory, exifMemorySize, context, ExifMemory);

        int64_t offset = 0;
        int64_t size = 0;
        NN_RESULT_DO(detail::ExtractJpegMakerNoteRange(&offset, &size, pFileData, fileSize, pExifMemory, exifMemorySize));

        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, MakerNoteOffset, offset);
        NN_CAPSRV_SCREENSHOT_CONTEXT_SET(context, MakerNoteSize, size);

        NN_RESULT_SUCCESS;
    }

}}}}}
