﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/image/image_ExifBuilder.h>
#include "../capsrvServer_Config.h"
#include "visrv_SoftwareJpegEncoderInfo.h"
#include "visrv_JpegDestinationMgrBase.h"
#include "../../capture/capsrv_ImageFormat.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    struct SoftwareJpegEncoderYuvBuffer
    {
        void* pBufferY;
        void* pBufferU;
        void* pBufferV;
        size_t bufferSizeY;
        size_t bufferSizeU;
        size_t bufferSizeV;
    };

    struct SoftwareJpegEncoderStreamInputInfoYuv
    {
        capture::ImageFormat format; ///< Pixel format
        uint32_t width;              ///< Image width(px)
        uint32_t height;             ///< Image height(px)

        // callback function for filling encoder input buffers
        nn::Result (*pGetSubRegionFunction)(const SoftwareJpegEncoderYuvBuffer& outBuffer, capture::ImageFormat format, uint32_t x, uint32_t y, uint32_t width, uint32_t height, void* userPtr);
        // user pointer for callback function
        void* pGetSubRegionUserPtr;
    };

    class SoftwareJpegEncoderYuv
    {
    public:

        static nn::Result EncodeYuvStreamToBuffer(
            SoftwareJpegEncoderBufferOutputInfo& outputInfo,
            const SoftwareJpegEncoderStreamInputInfoYuv& inputInfo,
            int quality,
            nn::image::ExifBuilder* pExifBuilder,
            void* pWorkBuffer,
            size_t workBufferSize
        ) NN_NOEXCEPT;

    private:
        static nn::Result EncodeYuvStreamImpl(
            JpegDestinationMgrBase& destMgr,
            const SoftwareJpegEncoderStreamInputInfoYuv& inputInfo,
            int quality,
            bool hasExif,
            void* pWorkBuffer,
            size_t workBufferSize
        ) NN_NOEXCEPT;
    };

}}}}
