﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SoftwareJpegEncoderYuv.h"

#include <csetjmp>

#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/image/image_JpegEncoder.h>
#include "../capsrvServer_Config.h"
#include "../capsrvServer_ResultPrivate.h"
#include "visrv_WriteJpegHeaderDataWithExif.h"
#include "visrv_JpegDestinationMgrForBufferWithExif.h"

namespace nn{ namespace capsrv{ namespace server{ namespace jpeg{

    nn::Result SoftwareJpegEncoderYuv::EncodeYuvStreamToBuffer(
        SoftwareJpegEncoderBufferOutputInfo& outputInfo,
        const SoftwareJpegEncoderStreamInputInfoYuv& inputInfo,
        int quality,
        nn::image::ExifBuilder* pExifBuilder,
        void* pWorkBuffer,
        size_t workBufferSize
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(outputInfo.pBuffer);
        NN_SDK_REQUIRES_NOT_NULL(outputInfo.pOutSize);
        NN_SDK_REQUIRES_EQUAL(inputInfo.width  % (8u * GetHorizontalSubsampling(inputInfo.format)), 0u); // Subsampled width  must be a multiple of the JPEG DCT size
        NN_SDK_REQUIRES_EQUAL(inputInfo.height % (8u * GetVerticalSubsampling(inputInfo.format)),   0u); // Subsampled height must be a multiple of the JPEG DCT size
        NN_SDK_REQUIRES_NOT_NULL(inputInfo.pGetSubRegionFunction);
        NN_SDK_REQUIRES_NOT_NULL(pExifBuilder);

        uint8_t* dst = reinterpret_cast<uint8_t*>(outputInfo.pBuffer);
        size_t size  = outputInfo.bufferSize;

        // ヘッダ部分を書き出し
        size_t headerSize = GetJpegHeaderDataWithExifSize(pExifBuilder);
        {
            NN_RESULT_THROW_UNLESS(size >= headerSize, ResultInternalJpegOutBufferShortage());
            NN_RESULT_DO(WriteJpegHeaderDataWithExif(dst, size, pExifBuilder, inputInfo.width, inputInfo.height));
        }
        dst  += headerSize;
        size -= headerSize;

        // Jpeg エンコード
        size_t dataSize = 0;
        {
            JpegDestinationMgrForBufferWithExif dstMgr(dst, size);
            NN_RESULT_DO(EncodeYuvStreamImpl(dstMgr, inputInfo, quality, true, pWorkBuffer, workBufferSize));
            dataSize = dstMgr.GetWrittenSize();
            NN_SDK_ASSERT_GREATER_EQUAL(dataSize, 2u);
            dataSize -= 2;
        }
        dst  += dataSize;
        size -= dataSize;

        *outputInfo.pOutSize = headerSize + dataSize;
        NN_RESULT_SUCCESS;
    }

}}}}
