﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/image/image_ExifBuilder.h>
#include "capsrvServer_MakerNoteInfo.h"

namespace nn{ namespace image{
    class ExifBuilder;
}}

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

    // @brief 与えられたメモリ上に ExifBuilder を作成します。
    // @return info の情報が設定された解析済の ExifBuilder へのポインタを返します。
    // @details
    // memory で与えられた領域内に ExifBuilder を作成します。
    nn::image::ExifBuilder* ConstructExifBuilder(void* memory, size_t memorySize, const MakerNoteInfo& info, const void* pThumbData, size_t thumbDataSize) NN_NOEXCEPT;

    // @brief ConstructExifBuilder で作成したインスタンスを破棄します。
    void DestructExifBuilder(nn::image::ExifBuilder* pBuilder) NN_NOEXCEPT;

}}}}
