﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_DecryptApplicationAlbumEntry.h"

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/capsrv/capsrv_Result.h>

#include "../albumsrv/capsrvServer_AlbumServerObject.h"
#include "../detail/capsrvServer_ApplicationResourceManager.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{

// ApplicationAlbumEntry を復号して AlbumEntry を返す。
// 対象ファイルの applicationId が一致しない場合は NotFound を返す。
Result DecryptApplicationAlbumEntryAndCheckApplicationId(AlbumEntry* pOutEntry, const ApplicationAlbumEntry& srcEntry, const ncm::ApplicationId& applicationId) NN_NOEXCEPT
{
    // 鍵の取得
    detail::ApplicationAlbumEntryKey key = {};
    NN_RESULT_THROW_UNLESS(g_ApplicationResourceManager.GetApplicationAlbumEntryKeyFromApplicationId(&key, applicationId).IsSuccess(), ResultAlbumError());

    // 復号
    AlbumEntry entry = detail::GetAlbumEntryFromApplicationAlbumEntry(srcEntry, key);

    // applicationId の一致確認
    NN_RESULT_THROW_UNLESS(applicationId == entry.fileId.applicationId, ResultAlbumFileNotFound());

    // AlbumFileId 値が妥当か検査
    NN_RESULT_THROW_UNLESS(album::AlbumPathUtility::ValidateFileId(&entry.fileId, g_EnvironmentInfo).IsSuccess(), ResultAlbumError());

    *pOutEntry = entry;
    NN_RESULT_SUCCESS;
}

}}}}
