﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumContentsAttribute.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_AlbumFileSizeLimit.h>
#include "../capsrvServer_Config.h"

namespace nn{ namespace capsrv{ namespace server{ namespace detail{
    NN_STATIC_ASSERT(nn::capsrv::AlbumFileSizeLimit_ScreenShot == ScreenShotImageSizeLimit);
    NN_STATIC_ASSERT(nn::capsrv::AlbumFileSizeLimit_Movie == MovieSizeLimit);

    const char* AlbumContentsAttribute::GetFileExtension(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT
    {
        if((env.IsAlbumScreenShotFileSupported() && contents == AlbumFileContents_ScreenShot) ||
           (env.IsAlbumExtraScreenShotFileSupported() && contents == AlbumFileContents_ExtraScreenShot))
        {
            return NN_CAPSRV_CONTENTS_EXTENSION_SCREENSHOT;
        }

        if((env.IsAlbumMovieFileSupported() && contents == AlbumFileContents_Movie) ||
           (env.IsAlbumExtraMovieFileSupported() && contents == AlbumFileContents_ExtraMovie))
        {
            return NN_CAPSRV_CONTENTS_EXTENSION_MOVIE;
        }

        return nullptr;
    }

    int AlbumContentsAttribute::GetFileExtensionLength(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT
    {
        NN_UNUSED(contents);
        NN_UNUSED(env);
        return 4;
    }

    size_t AlbumContentsAttribute::GetFileSizeLimit(AlbumFileContentsType contents, const EnvironmentInfo& env) NN_NOEXCEPT
    {
        if (!env.IsAlbumFileContentsSupported(contents))
        {
            return 0;
        }
        return GetAlbumFileSizeLimitImpl(contents);
    }

}}}}

