﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "decodersrv_InitializeForDecoderServer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
//#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/capsrv/capsrv_Result.h>

#include "decodersrv/decodersrv_DecoderServerObject.h"


#define NN_CAPSRV_STRONG_REQUIRES(expr) \
    NN_SDK_REQUIRES(expr);  \
    NN_ABORT_UNLESS(expr);

namespace nn{ namespace capsrv{ namespace server{

    //namespace{
    //    nn::Result LoadSettingValue(bool* pOutValue, const char* key) NN_NOEXCEPT
    //    {
    //        NN_SDK_ASSERT_NOT_NULL(pOutValue);

    //        bool value = false;
    //        auto size = settings::fwdbg::GetSettingsItemValue(&value, sizeof(value), "capsrv", key);
    //        NN_RESULT_THROW_UNLESS(
    //            size == sizeof(value),
    //            nn::capsrv::ResultInternalError()
    //        );

    //        *pOutValue = value;
    //        NN_RESULT_SUCCESS;
    //    }
    //}


    namespace {
        bool g_IsInitialized = false;
    }

    nn::Result InitializeForDecoderServer() NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(!g_IsInitialized);

        std::memset(&g_WorkMemory, 0, sizeof(g_WorkMemory));

        NN_ABORT_UNLESS_RESULT_SUCCESS(g_DecoderControlServerManager.Initialize());

        g_DecoderControlServerManager.StartServer();

        g_IsInitialized = true;
        NN_RESULT_SUCCESS;
    }

    void FinalizeForDecoderServer() NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(g_IsInitialized);

        g_DecoderControlServerManager.Finalize();

        g_IsInitialized = false;
    }

    void DecoderControlServerThreadFunction(void*) NN_NOEXCEPT
    {
        NN_CAPSRV_STRONG_REQUIRES(g_IsInitialized);
        g_DecoderControlServerManager.RunServer();
    }

}}}
