﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "decodersrv_DecoderControlServerManager.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/sf/capsrv_ServiceName.h>

namespace nn{ namespace capsrv{ namespace server{

    nn::Result DecoderControlServerManager::Initialize() NN_NOEXCEPT
    {
        m_ServiceHolder.emplace();
        m_ServerManager.emplace();

        NN_ABORT_UNLESS_RESULT_SUCCESS(m_ServerManager->RegisterObjectForPort(
            m_ServiceHolder->GetShared(),
            SessionCountMax,
            sf::DecoderControlServiceName
        ));

        nn::os::InitializeEvent(&m_IsIdleEvent, true, nn::os::EventClearMode_ManualClear);

        NN_RESULT_SUCCESS;
    }

    void DecoderControlServerManager::Finalize() NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(nn::os::TryWaitEvent(&m_IsIdleEvent));
        nn::os::FinalizeEvent(&m_IsIdleEvent);
        m_ServerManager = nn::util::nullopt;
        m_ServiceHolder = nn::util::nullopt;
    }

    void DecoderControlServerManager::StartServer() NN_NOEXCEPT
    {
        m_ServerManager->Start();
    }

    void DecoderControlServerManager::StopServer() NN_NOEXCEPT
    {
        m_ServerManager->RequestStop();
        nn::os::WaitEvent(&m_IsIdleEvent);
    }

    void DecoderControlServerManager::RunServer() NN_NOEXCEPT
    {
        // TORIAEZU:
        // 排他としては不十分だが実用上問題ない。
        NN_ABORT_UNLESS(nn::os::TryWaitEvent(&m_IsIdleEvent));
        nn::os::ClearEvent(&m_IsIdleEvent);

        m_ServerManager->LoopAuto();

        nn::os::SignalEvent(&m_IsIdleEvent);
    }

}}}
