﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace server{

    nn::Result InitializeForAlbumServer() NN_NOEXCEPT;

    void FinalizeForAlbumServer() NN_NOEXCEPT;

    // AlbumControlServer(caps:c) 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void AlbumControlServerThreadFunction(void* pUnused) NN_NOEXCEPT;

    // AlbumServer(caps:a) 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void AlbumServerThreadFunction(void* pUnused) NN_NOEXCEPT;

    // AlbumWorker 用スレッドの関数。
    // @param[in] pUnused 参照されないため nullptr で構わない。
    void AlbumWorkerThreadFunction(void* pUnused) NN_NOEXCEPT;

}}}
