﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os/os_SdkMutex.h>

#include "../album/capsrvServer_AlbumManager.h"
#include "../album/capsrvServer_AlbumFileIdGenerator.h"
#include "../detail/capsrvServer_ApplicationResourceManager.h"
#include "../detail/capsrvServer_OverlayThumbnailHolder.h"
#include "../capsrvServer_EnvironmentInfo.h"
#include "../capsrvServer_ResourceIdManager.h"
#include "capsrvServer_AlbumErrorConverter.h"
#include "capsrvServer_AlbumWorkMemory.h"
#include "../album/capsrvServer_AlbumMovieUtility.h"

#if defined(NN_CAPSRV_USE_HIPC)
#include "capsrvServer_AlbumControlServerManager.h" // NOLINT(analysis/include)
#include "capsrvServer_AlbumServerManager.h"        // NOLINT(analysis/include)
#include "capsrvServer_AlbumRequestQueue.h"
#include "capsrvServer_AlbumWorker.h"
#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)
#include "capsrvServer_AlbumControlServerManager.h" // NOLINT(analysis/include)
#include "capsrvServer_AlbumServerManager.h"        // NOLINT(analysis/include)
#endif

namespace nn{ namespace capsrv{ namespace server{

    extern AlbumWorkMemory                g_AlbumWorkMemory;
    extern ResourceIdManager              g_ResourceIdManager;
    extern EnvironmentInfo                g_EnvironmentInfo;

    extern album::AlbumManager            g_AlbumManager;
    extern album::AlbumFileIdGenerator    g_AlbumFileIdGenerator;
    extern detail::ApplicationResourceManager g_ApplicationResourceManager;
    extern detail::OverlayThumbnailHolder g_OverlayThumbnailHolder;

    extern AlbumErrorConverter            g_AlbumErrorConverter;
    extern album::AlbumMovieUtilityStaticObject g_AlbumMovieUtilityStaticObject;

#if defined(NN_CAPSRV_USE_HIPC)
    extern AlbumControlServerManager      g_AlbumControlServerManager;
    extern AlbumServerManager             g_AlbumServerManager;
    extern os::SdkMutexType               g_AlbumGlobalMutex;
#elif defined(NN_CAPSRV_USE_DIRECT_FUNCTION_CALL)
    extern AlbumControlServerManager      g_AlbumControlServerManager;
    extern AlbumServerManager             g_AlbumServerManager;
#endif

}}}
