﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "capsrvServer_AlbumErrorConverter.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../capsrvServer_ConvertResult.h"

namespace nn{ namespace capsrv{ namespace server{

    void AlbumErrorConverter::Initialize() NN_NOEXCEPT
    {
        m_IsConversionEnabled = true;
    }

    void AlbumErrorConverter::Finalize() NN_NOEXCEPT
    {
    }

    void AlbumErrorConverter::SetConversionEnabled(bool value) NN_NOEXCEPT
    {
        m_IsConversionEnabled = value;
    }

    nn::Result AlbumErrorConverter::Convert(nn::Result value) const NN_NOEXCEPT
    {
        if(!m_IsConversionEnabled)
        {
            return value;
        }

        return ConvertResult(value);
    }


}}}
