﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/sf/capsrv_Services.sfdl.h>

namespace nn{ namespace capsrv{ namespace server{

    class AlbumControlServiceImpl
    {
    public:
        nn::Result NotifyAlbumStorageIsAvailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result NotifyAlbumStorageIsUnavailable(nn::capsrv::AlbumStorageType storage) NN_NOEXCEPT;
        nn::Result RegisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result UnregisterAppletResourceUserId(nn::applet::AppletResourceUserId aruid, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GenerateCurrentAlbumFileId(nn::sf::Out<nn::capsrv::AlbumFileId> outFileId, nn::ncm::ProgramId programId, nn::capsrv::AlbumFileContentsType contentType) NN_NOEXCEPT;
        nn::Result GenerateApplicationAlbumEnrty(nn::sf::Out<nn::capsrv::ApplicationAlbumEntry> outEntry, const nn::capsrv::AlbumEntry& srcEntry, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result GetApplicationIdFromAruid(nn::sf::Out<nn::ncm::ApplicationId> outApplicationId, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CheckApplicationIdRegistered(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result SaveAlbumScreenShotFileEx(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& fileData, std::uint64_t makerNoteVersion, std::int64_t makerNoteOffset, std::int64_t makerNoteSize) NN_NOEXCEPT;
        nn::Result SetOverlayScreenShotThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
        nn::Result SetOverlayMovieThumbnailData(const nn::capsrv::AlbumFileId& fileId, const nn::sf::InBuffer& thumbData) NN_NOEXCEPT;
        nn::Result OpenControlSession(nn::sf::Out<nn::sf::SharedPointer<nn::capsrv::sf::IAlbumControlSession>> outValue, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    };

}}}
