﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/capsrv/capsrv_AlbumFileId.h>
#include <nn/capsrv/capsrv_ScreenShotAttribute.h>
#include <nn/capsrv/capsrv_AppletData.h>
#include <nn/capsrv/capsrv_ApplicationData.h>
#include <nn/capsrv/capsrv_SystemReservedInfo.h>
#include "../capsrvServer_EnvironmentInfo.h"
#include "../detail/capsrvServer_MakerNoteInfo.h"

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    enum FileDataRange
    {
        FileDataRange_WholeFile,
        FileDataRange_HeaderOnly,
    };

    nn::Result VerifyAndLoadScreenShotMakerNoteInfoImpl(
        nn::capsrv::server::detail::MakerNoteInfo* pOutMakerNoteInfo,
        const AlbumFileId* pFileId,
        const void* pFileData,
        size_t fileDataSize,
        const EnvironmentInfo& env,
        FileDataRange fileDataRange
        ) NN_NOEXCEPT;

    // @brief ファイルの内容が正当か検査する
    // @pre pFileId != nullptr
    // @pre pFileData != nullptr
    // @pre fileDataSize > 0
    // @pre IsValid(fileId)
    // @retval nn::ResultSuccess 正当なファイルデータだった
    nn::Result VerifyScreenShotFileData(
        const AlbumFileId* pFileId,
        const void* pFileData,
        size_t fileDataSize,
        const EnvironmentInfo& env
        ) NN_NOEXCEPT;

    // pOutAttribute == nullptr の場合値を書き込まない。
    // pOutAppletData == nullptr の場合値を書き込まない。
    // pOutSystemReservedInfo == nullptr の場合値を書き込まない。
    nn::Result VerifyScreenShotFileDataEx(
        ScreenShotAttribute* pOutAttribute,
        nn::capsrv::AppletData* pOutAppletData,
        nn::capsrv::ApplicationData* pOutApplicationData,
        nn::capsrv::SystemReservedInfo* pOutSystemReservedInfo,
        const AlbumFileId* pFileId,
        const void* pFileData,
        size_t fileDataSize,
        const EnvironmentInfo& env
        ) NN_NOEXCEPT;

    // @brief ファイルの先頭部分が正当か検査する
    // @pre pFileId != nullptr
    // @pre pFileHeader != nullptr
    // @pre fileHeaderSize > 0
    // @pre IsValid(fileId)
    // @retval nn::ResultSuccess 正当なファイルデータだった
    // @details
    //   ファイルの先頭部分の正当性を確認します。
    //   渡すデータはファイルの先頭から少なくとも Exif 全体が収まっている範囲である必要があります。
    //   Exif 仕様によりファイルの先頭から 64KB 程度を入力すれば十分です。
    nn::Result VerifyScreenShotFileHeader(
        const AlbumFileId* pFileId,
        const void* pFileHeader,
        size_t fileHeaderSize,
        const EnvironmentInfo& env
        ) NN_NOEXCEPT;

    // pOutAttribute == nullptr の場合値を書き込まない。
    // pOutAppletData == nullptr の場合値を書き込まない。
    // pOutSystemReservedInfo == nullptr の場合値を書き込まない。
    nn::Result VerifyScreenShotFileHeaderEx(
        ScreenShotAttribute* pOutAttribute,
        nn::capsrv::AppletData* pOutAppletData,
        nn::capsrv::ApplicationData* pOutApplicationData,
        nn::capsrv::SystemReservedInfo* pOutSystemReservedInfo,
        const AlbumFileId* pFileId,
        const void* pFileHeader,
        size_t fileHeaderSize,
        const EnvironmentInfo& env
        ) NN_NOEXCEPT;
}}}}
