﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace capsrv{ namespace server{ namespace album{

    // @brief JPEG の先頭部分からサムネイルを取得します
    // @param[out] pOutSize        取得したサムネイルの大きさ（バイト）
    // @param[out] pOutBuffer      サムネイルを取得するバッファ
    // @param[in] bufferSize       pOutBuffer の大きさ（バイト）
    // @param[in] pJpegHeadData    サムネイルを取得する JPEG の先頭部分のバイナリ列
    // @param[in] jpegHeadDataSize pJpegHeadData の大きさ（バイト）
    // @detail
    //   JPEG からサムネイルを取得します。
    //   サムネイルを取得するのに十分な大きさがあればファイル全体を渡す必要はありません。
    //   取得したサムネイルはバッファにコピーされます。
    //   サムネイルの検査は行いません。
    nn::Result ExtractJpegThumbnail(
        size_t* pOutSize,
        void* pOutBuffer,
        size_t bufferSize,
        const void* pJpegHeadData,
        size_t jpegHeadDataSize
    ) NN_NOEXCEPT;


}}}}
