﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/capsrv/capsrv_Result.h>
#include "../../capsrv_Macro.h"
#include "../capsrvServer_ResultPrivate.h"
#include "../albumsrv/capsrvServer_AlbumWorkMemory.h"
#include "capsrvServer_AlbumFileManipulator.h"
#include "capsrvServer_AlbumFileLockTable.h"

#define NN_CAPSRV_ALBUMMANAGER_REQUIRES_AND_CLEAR_WORKMEMORY() \
    NN_SDK_REQUIRES_NOT_NULL(m_Memory);   \
    NN_SDK_REQUIRES_ALIGNED(m_Memory, AlbumWorkMemoryAlignment_Default);   \
    NN_SDK_REQUIRES_GREATER_EQUAL(m_MemorySize, static_cast<size_t>(AlbumWorkMemorySize_AlbumManagerWorkBuffer)); \
    std::memset(m_Memory, 0, m_MemorySize); \
    NN_UTIL_SCOPE_EXIT{ std::memset(m_Memory, 0, m_MemorySize); };

#define NN_CAPSRV_CREATE_FILEPATH(varName, fileId, direction)                      \
    AlbumFilePath varName = {};                                         \
    NN_RESULT_DO(AlbumFileManipulator::GetFilePath(&varName, (fileId), (direction), *m_pEnvironmentInfo));

#define NN_CAPSRV_OPEN_FILE_TO_READ(varName, filepath)                  \
    AlbumFileHandle varName = {};                                       \
    NN_RESULT_DO(                                                       \
        AlbumFileManipulator::OpenAlbumFileForLoad(&varName, filepath) \
    );                                                                  \
    NN_UTIL_SCOPE_EXIT{ AlbumFileManipulator::CloseAlbumFile(varName); };

#define NN_CAPSRV_GET_FILESIZE_TO_READ(varName, fileId, handle)         \
    int64_t varName = 0;                                                \
    NN_RESULT_DO(AlbumFileManipulator::GetFileSize(&varName, (handle)));    \
    NN_RESULT_THROW_UNLESS(                                             \
        varName <= static_cast<int64_t>(nn::capsrv::server::detail::AlbumContentsAttribute::GetFileSizeLimit((fileId).contents, *m_pEnvironmentInfo)), \
        ResultAlbumFileNotFound()                                       \
    );

#define NN_CAPSRV_CHECK_FILE_NOT_READ_LOCKED(fileId, failResult)    \
    if(m_ReadLockFileTable.IsFileLocked(fileId))               \
    {                                                           \
        NN_RESULT_THROW(failResult);                            \
    }

#define NN_CAPSRV_CHECK_FILE_NOT_WRITE_LOCKED(fileId, failResult)    \
    if(m_WriteLockFileTable.IsFileLocked(fileId))               \
    {                                                           \
        NN_RESULT_THROW(failResult);                            \
    }
